% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scrappy.R
\name{newa_nrcc}
\alias{newa_nrcc}
\title{Retrieve data from NEWA at Cornell University}
\usage{
newa_nrcc(
  client,
  year,
  month,
  station,
  base = "http://newa.nrcc.cornell.edu/newaLister",
  interval = "hly",
  sleep = 6,
  table_id = "#dtable",
  path = getwd(),
  save_file = TRUE
)
}
\arguments{
\item{client}{\code{RSelenium} client.}

\item{year}{Numeric value with the year.}

\item{month}{Numeric value with the month.}

\item{station}{String with the station abbreviation. Check the
\url{http://newa.cornell.edu/index.php?page=station-pages} for a list.}

\item{base}{Base URL
(default: \url{http://newa.nrcc.cornell.edu/newaLister}).}

\item{interval}{String with data interval (default: hly, hourly).}

\item{sleep}{Numeric value with the number of seconds to wait for the page
to load the results (default: 6 seconds).}

\item{table_id}{String with the unique HTML ID assigned to the table
containing the data (default: \code{#dtable})}

\item{path}{String with path to location where CSV files should be stored
(default: \code{getwd()}).}

\item{save_file}{Boolean flag to indicate whether or not the output should
be stored as a CSV file.}
}
\value{
Tibble with the data retrieved from the server.
}
\description{
Retrieve Weather data from the Network for Environment and Weather
Applications (NEWA) at Cornell University.
}
\examples{
\dontrun{
# Create RSelenium session
rD <- RSelenium::rsDriver(browser = "firefox", port = 4544L, verbose = FALSE)
# Retrieve data for the Geneva (Bejo) station on 2020/12
scrappy::newa_nrcc(rD$client, 2020, 12, "gbe")
# Stop server
rD$server$stop()
}
}
