% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scatterPlotMatrix.R
\name{scatterPlotMatrix}
\alias{scatterPlotMatrix}
\title{\code{htmlwidget} for \code{d3.js} scatter plot matrix}
\usage{
scatterPlotMatrix(
  data,
  categorical = NULL,
  inputColumns = NULL,
  cutoffs = NULL,
  keptColumns = NULL,
  zAxisDim = NULL,
  distribType = 2,
  regressionType = 0,
  corrPlotType = "Circles",
  corrPlotCS = NULL,
  rotateTitle = FALSE,
  columnLabels = NULL,
  continuousCS = "Viridis",
  categoricalCS = "Category10",
  mouseMode = "tooltip",
  eventInputId = NULL,
  controlWidgets = FALSE,
  cssRules = NULL,
  plotProperties = NULL,
  slidersPosition = NULL,
  width = NULL,
  height = NULL,
  elementId = NULL
)
}
\arguments{
\item{data}{\code{data.frame} with data to use in the chart.}

\item{categorical}{List of list (one for each data column) containing the name of available categories,
or \code{NULL} if column corresponds to continuous data;
\code{NULL} is allowed, meaning all columns are continuous.
A named list can also be provided to only indicate which columns are categorical,
associating available categories to a column name.}

\item{inputColumns}{List of boolean (one for each data column),
\code{TRUE} for an input column, \code{FALSE} for an output column;
\code{NULL} is allowed, meaning all columns are inputs.
A list of column names can also be provided to only indicate which columns are inputs.}

\item{cutoffs}{List of \code{SpCutoff};
a \code{SpCutoff} is a list defining a \code{xDim}, \code{yDim} and a list of \code{xyCutoff};
a \code{xyCutoff} is a pair of \code{cutoff} (one for x axis, one for y axis);
a \code{cutoff} is a list containing two values (min and max values)
or \code{NULL} if there is no cutoff to apply for this axis;
\code{NULL} is allowed, meaning there is no cutoff to apply.}

\item{keptColumns}{List of boolean (one for each data column), \code{FALSE} if column has to be ignored;
\code{NULL} is allowed, meaning all columns are available.
A list of column names can also be provided to only indicate
which columns are to be kept.}

\item{zAxisDim}{Name of the column represented by z axis
(used to determine the color to attribute to a point);
\code{NULL} is allowed, meaning there is no coloring to apply.}

\item{distribType}{Binary code indicating the type of distribution plot
(bit 1: density plot, bit 2: histogram).}

\item{regressionType}{Binary code indicating the type of regression plot (bit 1: linear, bit 2: loess).}

\item{corrPlotType}{String indicating the type of correlation plots to use.
Supported values:
\itemize{
\item \code{Circles} to use a circle tree map;
\item \code{Text} to display values of correlation as colored text labels
(color scale domain is \verb{[-1; 1]});
\item \code{AbsText} to display values of correlation as colored text labels
(color scale domain is \verb{[0; 1]}, absolute value of correlations is used);
\item \code{Empty} to not display values of correlation;
default value is \code{Circles}.
}}

\item{corrPlotCS}{Name of the color Scale to use for correlation plot
when plot type is \code{Text} or \code{AbsText};
supported names: \code{Viridis}, \code{Inferno}, \code{Magma}, \code{Plasma}, \code{Warm}, \code{Cool}, \code{Rainbow},
\code{CubehelixDefault}, \code{Blues},\code{Greens}, \code{Greys}, \code{Oranges}, \code{Purples}, \code{Reds}, \code{BuGn},
\code{BuPu}, \code{GnBu}, \code{OrRd}, \code{PuBuGn}, \code{PuBu}, \code{PuRd}, \code{RdBu}, \code{RdPu}, \code{YlGnBu}, \code{YlGn},
\code{YlOrBr}, \code{YlOrRd};
default value is \code{NULL}, which corresponds to \code{RdBu} if \code{corrPlotType} is \code{Text},
or \code{Blues} if \code{corrPlotType} is \code{AbsText}.}

\item{rotateTitle}{\code{TRUE} if column title must be rotated.}

\item{columnLabels}{List of string (one for each data column) to display
in place of column name found in data,
or \code{NULL} if there is no alternative name;
\code{NULL} is allowed, meaning all columns are without alternative name;
\verb{<br>} can be used to insert line breaks.}

\item{continuousCS}{Name of the color Scale to use for continuous data;
supported names: \code{Viridis}, \code{Inferno}, \code{Magma}, \code{Plasma}, \code{Warm}, \code{Cool}, \code{Rainbow},
\code{CubehelixDefault}, \code{Blues}, \code{Greens}, \code{Greys}, \code{Oranges}, \code{Purples}, \code{Reds}, \code{BuGn},
\code{BuPu}, \code{GnBu}, \code{OrRd}, \code{PuBuGn}, \code{PuBu}, \code{PuRd}, \code{RdBu}, \code{RdPu}, \code{YlGnBu}, \code{YlGn},
\code{YlOrBr}, \code{YlOrRd};
default value is \code{Viridis}.}

\item{categoricalCS}{Name of the color Scale to use for categorical data;
supported names: \code{Category10}, \code{Accent}, \code{Dark2}, \code{Paired}, \code{Set1};
default value is \code{Category10}.}

\item{mouseMode}{Type of mouse interaction. Three types are available: \code{tooltip}, \code{filter} or \code{zoom}.}

\item{eventInputId}{When plot event occurred, reactive input to write to;
\code{NULL} is allowed, meaning no event is sent.
An event is a list with two named elements 'type' and 'value'.
\itemize{
\item If \code{type} is equal to \code{zAxisChange}:
\itemize{
\item \code{value} is the new column to use as reference (see \code{zAxisDim} argument).
}
\item If \code{type} is equal to \code{cutoffChange}:
\itemize{
\item \code{value$adjusting} is \code{TRUE} when pointer is moving, changing a cutoff;
\item \code{value$cutoffs} gives the new values for the cutoffs.
}
\item If \code{type} is equal to \code{pointClicked}:
\itemize{
\item \code{value$pointIndex} is the index of the clicked point.
}
}}

\item{controlWidgets}{Tells if some widgets must be available to control plot;
\code{NULL} is allowed, meaning that \code{!HTMLWidgets.shinyMode} is to use;
default value is \code{FALSE}.}

\item{cssRules}{CSS rules to add.
Must be a named list of the form list(selector = declarations),
where selector is a valid CSS selector and declarations is
a string or vector of declarations.}

\item{plotProperties}{Adjust some properties which can not be set through CSS
(mainly size, color and opacity of points).
Default value is \code{NULL} which is equivalent to:

\if{html}{\out{<div class="sourceCode">}}\preformatted{  list(
    noCatColor = "#43665e",
    watermarkColor = "#ddd",
    point = list(
      alpha = 0.5,
      radius = 2
    ),
    regression = list(
      strokeWidth = 4
    )
  )
}\if{html}{\out{</div>}}}

\item{slidersPosition}{Set initial position of sliders, specifying which columns intervals are visible.
Default value is \code{NULL} which is equivalent to:

\if{html}{\out{<div class="sourceCode">}}\preformatted{  list(
    dimCount = 8,
    xStartingDimIndex = 1,
    yStartingDimIndex = 1
  )
}\if{html}{\out{</div>}}}

\item{width}{Integer in pixels defining the width of the widget.}

\item{height}{Integer in pixels defining the height of the widget.}

\item{elementId}{Unique \code{CSS} selector id for the widget.}
}
\description{
\code{htmlwidget} for \code{d3.js} scatter plot matrix
}
\examples{
 if(interactive()) {
   library(scatterPlotMatrix)

   scatterPlotMatrix(iris, zAxisDim = "Species")
   # Each point has a color depending of its 'Species' value

   categorical <-
     list(cyl = c(4, 6, 8), vs = c(0, 1), am = c(0, 1), gear = 3:5, carb = 1:8)
   scatterPlotMatrix(mtcars, categorical = categorical, zAxisDim = "cyl")
   # 'cyl' and four last columns have a box representation for categories
   # (use top slider to see the last three columns)

   scatterPlotMatrix(iris, zAxisDim = "Species", distribType = 1)
   # Distribution plots are of type 'density plot' (instead of histogram)

   scatterPlotMatrix(iris, zAxisDim = "Species", regressionType = 1)
   # Add linear regression plots

   columnLabels <- gsub("\\\\.", "<br>", colnames(iris))
   scatterPlotMatrix(iris, zAxisDim = "Species", columnLabels = columnLabels)
   # Given names are displayed in place of dataset column names;
   # <br> is used to insert line breaks

   scatterPlotMatrix(iris, cssRules = list(
       ".jitterZone" = "fill: pink",
       ".tick text" = c("fill: red", "font-size: 1.8em")
   ))
   # Background of plot is pink and text of axes ticks is red and greater

   scatterPlotMatrix(iris, plotProperties = list(
     noCatColor = "DarkCyan",
     point = list(
       alpha = 0.3,
       radius = 4
     )
   ))
   # Points of plots are different:
   # two times greater, with opacity reduced from 0.5 to 0.3, and a `DarkCyan` color

 }

}
