% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/n.means.R
\name{n.means}
\alias{n.means}
\title{Sample Size for Comparing Independent and dependent means}
\usage{
n.means(
  delta,
  sd,
  alp = 0.05,
  pwr = 0.8,
  type = "two",
  alternative = "two.sided",
  k = 1,
  paired = FALSE
)
}
\arguments{
\item{delta}{anticipated difference between the two groups}

\item{sd}{anticipated standard deviation}

\item{alp}{anticipated level of significance or accepted level of type I error \code{alp=0.05} is default}

\item{pwr}{desired power \code{pwr=0.80} is default}

\item{type}{string specifying the type of sample (one or two) \code{type=two} is default}

\item{alternative}{one or two sided alternative hypothesis \code{"two.sided"} is default}

\item{k}{the ratio of control to experimental patients \code{k=1} is default}

\item{paired}{a logical argument indicating whether the sample is independent or dependent \code{FALSE} is default}
}
\value{
a list object, the required minimum sample size along with description for reporting
}
\description{
This function computes the sample size based on three different methods
i) comparing mean with a specified value
ii) comparing two  independent means
iii) comparing two dependent means
}
\examples{
n.means(delta = 1.5, sd = 1, alp = 0.05, pwr = 0.9, type ="two",
alternative= "two.sided", k = 1, paired = FALSE)
}
\references{
Lwanga, S. K., Lemeshow, S., & World Health Organization. (1991).
Sample size determination in health studies: a practical manual. World Health Organization.
}
\author{
R. Amala, Scientist-C, ICMR-VCRC, Puducherry  & G. Kumarapandiyan, Asst. Prof., Madras Christian College, Chennai
}
