% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/project_bias.R
\name{project_bias}
\alias{project_bias}
\title{Projecting Bias Effects in Space}
\usage{
project_bias(x, factors = NULL)
}
\arguments{
\item{x}{an object of the class \code{sampbias}.}

\item{factors}{a character vector indicating which biasing factors to project}
}
\value{
A raster stack, with the same length as the number of biasing factors
  used in \code{\link{calculate_bias}}. The names indicate the factors
  included for each layer.
}
\description{
Uses the the estimated bias weights from a \code{sampbias} object to project
the bias through space, using the same raster as used for the distance
calculation.#'
}
\examples{

\donttest{
  #simulate data
  occ <- data.frame(species = rep(sample(x = LETTERS, size = 5), times = 10),
                   decimalLongitude = runif(n = 50, min = 12, max = 20),
                   decimalLatitude = runif(n = 50, min = -4, max = 4))

  out <- calculate_bias(x = occ, terrestrial = TRUE)
  proj <- project_bias(out)
}

}
\seealso{
\code{\link{calculate_bias}}, \code{\link{summary.sampbias}}
}
\keyword{methods}
