% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interpolate_rt.R, R/methods-cv.R, R/methods.R
\name{interpolate_rt}
\alias{interpolate_rt}
\alias{interpolate_rt.cv_poisson_rt}
\alias{interpolate_rt.poisson_rt}
\title{Interpolate (or extrapolate) Rt estimates to intermediate design points}
\usage{
interpolate_rt(object, xout, ...)

\method{interpolate_rt}{cv_poisson_rt}(object, xout, which_lambda = c("lambda.min", "lambda.1se"), ...)

\method{interpolate_rt}{poisson_rt}(object, xout, lambda = NULL, ...)
}
\arguments{
\item{object}{A fitted object produced by \code{estimate_rt()} or \code{cv_estimate_rt()}.}

\item{xout}{a vector of new positions at which Rt should be produced,
but where counts may not have been observed.}

\item{...}{additional arguments passed to methods.}

\item{which_lambda}{Select which lambdas from the object to use. If not
provided, all Rt's are returned. Note that new lambdas not originally
used in the estimation procedure may be provided, but the results will be
calculated by linearly interpolating the estimated Rt's.

The strings \code{lambda.min} or \code{lambda.1se} are allowed to choose either
the lambda that minimizes the cross validation score or the largest lambda
whose corresponding cross validation score is within 1 standard error of
the minimal cross validation score.}

\item{lambda}{Vector. A user supplied sequence of tuning parameters which
determines the balance between data fidelity and
smoothness of the estimated Rt; larger \code{lambda} results in a smoother
estimate. The default, \code{NULL}
results in an automatic computation based on \code{nlambda}, the largest value
of \code{lambda} that would result in a maximally smooth estimate, and \code{lambda_min_ratio}.
Supplying a value of \code{lambda} overrides
this behaviour. It is likely better to supply a
decreasing sequence of \code{lambda} values than a single (small) value. If
supplied, the user-defined \code{lambda} sequence is automatically sorted in
decreasing order.}
}
\value{
A vector or matrix of interpolated Rt estimates.
}
\description{
Interpolate (or extrapolate) Rt estimates to intermediate design points
}
\examples{
y <- c(1, rpois(100, dnorm(1:100, 50, 15) * 500 + 1))
out <- estimate_rt(y)

# originally estimated at
out$x

# get the Rt at 3 new points (for all estimated lambdas)
int <- interpolate_rt(out, c(10.5, 11.5, 12.5))

# get the Rt at a single value of lambda
interpolate_rt(out, c(10.5, 11.5, 12.5), lambda = out$lambda[20])

y <- c(1, rpois(100, dnorm(1:100, 50, 15) * 500 + 1))
out <- estimate_rt(y, nsol = 10)
interpolate_rt(out, xout = c(1.5, 2.5))
}
