% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/colby_constructors.R
\name{add_overall_col}
\alias{add_overall_col}
\title{Add overall column}
\usage{
add_overall_col(lyt, label)
}
\arguments{
\item{lyt}{(\code{PreDataTableLayouts})\cr layout object pre-data used for tabulation.}

\item{label}{(\code{string})\cr a label (not to be confused with the name) for the object/structure.}
}
\value{
A \code{PreDataTableLayouts} object suitable for passing to further layouting functions, and to \code{\link[=build_table]{build_table()}}.
}
\description{
This function will \emph{only} add an overall column at the \emph{top} level of splitting, NOT within existing column splits.
See \code{\link[=add_overall_level]{add_overall_level()}} for the recommended way to add overall columns more generally within existing splits.
}
\examples{
lyt <- basic_table() \%>\%
  split_cols_by("ARM") \%>\%
  add_overall_col("All Patients") \%>\%
  analyze("AGE")
lyt

tbl <- build_table(lyt, DM)
tbl

}
\seealso{
\code{\link[=add_overall_level]{add_overall_level()}}
}
