% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rt_ticket_edit.R
\name{rt_ticket_edit}
\alias{rt_ticket_edit}
\title{Edit a ticket}
\usage{
rt_ticket_edit(
  ticket_id,
  queue = NULL,
  requestor = NULL,
  subject = NULL,
  cc = NULL,
  admin_cc = NULL,
  owner = NULL,
  status = NULL,
  priority = NULL,
  initial_priority = NULL,
  final_priority = NULL,
  time_estimated = NULL,
  starts = NULL,
  due = NULL,
  text = NULL,
  custom_field = NULL,
  ...
)
}
\arguments{
\item{ticket_id}{(numeric|character) The ticket number}

\item{queue}{(character) The queue}

\item{requestor}{(character) Requestor email address}

\item{subject}{(character) Ticket subject}

\item{cc}{(character) Email address to cc}

\item{admin_cc}{(character) Admin email address to cc}

\item{owner}{(character) Owner username or email}

\item{status}{(character) Ticket status; typically "open", "new", "stalled",
or "resolved"}

\item{priority}{(numeric) Ticket priority}

\item{initial_priority}{(numeric) Ticket initial priority}

\item{final_priority}{(numeric) Ticket final priority}

\item{time_estimated}{(character) Time estimated}

\item{starts}{(character) Starts}

\item{due}{(character) Due date}

\item{text}{(character) Ticket content; if multi-line, prefix every line with
a blank}

\item{custom_field}{(vector) Takes a named vector of the custom field name
and custom field value}

\item{...}{Other arguments passed to \code{\link{rt_POST}}}
}
\value{
(numeric) The ID of the ticket
}
\description{
Updates an existing ticket with new information.
}
\examples{
\dontrun{
# First, create a ticket
ticket <- rt_ticket_create("General")

# Then we can update its fields
rt_ticket_edit(ticket,
               requestor = "me@example.com",
               subject = "My subject")
}
}
