% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{rmtfit}
\alias{rmtfit}
\alias{rmtfit.default}
\alias{rmtfit.formula}
\title{Estimate restricted mean times in favor of treatment}
\usage{
rmtfit(...)

\method{rmtfit}{default}(id, time, status, trt, type = "multistate", ...)

\method{rmtfit}{formula}(formula, data, ...)
}
\arguments{
\item{...}{Further arguments.}

\item{id}{A vector of id variable.}

\item{time}{A vector of follow-up times.}

\item{status}{For \code{type="multistate"}, k = entering into state \eqn{k}
(\eqn{K+1} represents death) and 0 = censoring;
For \code{type="recurrent"}, 1 = recurrent event, 2 = death,
and 0 = censoring;}

\item{trt}{A vector of binary variable for treatment group.}

\item{type}{\code{"multistate"} = multistate data; \code{"recurrent"} =
recurrent event data.}

\item{formula}{A formula object. For multistate data, use \code{ms(id,time,status)~trt};
for recurrent event data, use \code{rec(id,time,status)~trt}.}

\item{data}{A data frame, which contains the variables names in the formula.}
}
\value{
An object of class \code{rmtfit}. See \code{\link{rmtfit.object}} for details.
}
\description{
Estimate and make inference on the overall and component-wise
restricted mean times in favor of treatment.
}
\section{Methods (by class)}{
\itemize{
\item \code{default}: Default

\item \code{formula}: Formula
}}

\examples{
#######################
# Multistate outcome  #
#######################
# load the colon cancer trial data
library(rmt)
head(colon_lev)
# fit the data
obj=rmtfit(ms(id,time,status)~rx,data=colon_lev)
# print the event numbers by group
obj
# summarize the inference results for tau=7.5 years
summary(obj,tau=7.5)

############################
# Recurrent event outcome  #
############################
# load the HF-ACTION trial data
library(rmt)
head(hfaction)
# fit the data
obj=rmtfit(rec(patid,time,status)~trt_ab,data=hfaction)
# print the event numbers by group
obj
# summarize the inference results for tau=3.5 years
summary(obj,tau=3.5,Kmax=4) # aggregating results for recurrent-event
# frequency >=4.


}
\seealso{
\code{\link{rmtfit.object}},
\code{\link{summary.rmtfit}}, \code{\link{plot.rmtfit}}, \code{\link{bouquet}}.
}
\keyword{rmtfit}
