\name{rhcoclust_network}
\alias{rhcoclust_network}

\title{
Visualization of clustering network plot
}
\description{
This function is used for visualization of clustering network plot, the plot objects are generated by rhcoclust.
}
\usage{
rhcoclust_network(CoClustObj)
}

\arguments{
  \item{CoClustObj}{
Output objects from rhcoclust
}

}


\value{
Plot
}

\author{
Md. Bahadur Badsha <mbbadshar@gmail.com>
}


\seealso{
\link{rhcoclust} for generating a graph objects for clustering network
}
\examples{
# Load necessary library
library(rhcoclust)
library(fields)
library(igraph)

# Load real data
data("FCGE_Data_GMP")
data("FCGE_Data_PPARs")
# Load predefined real data
# Real data use: data <- FCGE_Data_PPARs
# Real data use: data <- FCGE_Data_GMP

# Load predefined simulated data
data("simu_data")

# simulated data
data <- simu_data


# Apply rhcoclust to identify significant co-cluster of samples and their regulatory features
CoClustObj <- rhcoclust(data, rk=4, ck=3, method.dist = "manhattan", method.hclust = "ward.D")
# For real data either FCGE_Data_PPARs or FCGE_Data_GMP
#CoClustObj <- rhcoclust(data, rk=3, ck=3, method.dist = "manhattan", method.hclust = "ward.D")

# Visualization of clustering network plot
rhcoclust_network(CoClustObj)
}

