% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fchisq_test.R
\name{f_chisq_test}
\alias{f_chisq_test}
\title{Chi-squared Test with Post-hoc Analysis}
\usage{
f_chisq_test(
  x,
  y,
  p = NULL,
  method = "bonferroni",
  digits = 3,
  alpha = 0.05,
  force_posthoc = FALSE,
  ...
)
}
\arguments{
\item{x}{A numeric vector (or factor), or a contingency table in matrix or table form. If a data frame is entered the function will try to convert it to a table.}

\item{y}{A numeric vector; ignored if x is a matrix, table or data.frame. If x is a factor, y should be a factor of the same length.}

\item{p}{A vector of probabilities of the same length as x. Default is \code{NULL}. An error is given if any entry of p is negative.}

\item{method}{Character string specifying the adjustment method for p-values. Default is \code{"bonferroni"}. Other options include \code{"holm", "hochberg", "hommel", "BH", "BY", "fdr", and "none"}.}

\item{digits}{Integer specifying the number of decimal places for rounding. Default is \code{3}.}

\item{alpha}{Numeric threshold for significance. Default is \code{0.05}.}

\item{force_posthoc}{Logical indicating whether to perform post-hoc tests even if the chi-squared test is not significant. Default is \code{FALSE}.}

\item{...}{Additional arguments passed to \code{\link[stats]{chisq.test}}.}
}
\value{
An object of class f_chisq_test containing:
\itemize{
  \item \code{chisq_test_output}: The output from \code{\link[stats]{chisq.test}}.
  \item \code{adjusted_p_values}: Matrix of adjusted p-values (for table/matrix input).
  \item \code{observed_vs_adj_p_value}: Interleaved table of observed values and adjusted p-values.
  \item \code{stdres_vs_adj_p_value}: Interleaved table of standardized residuals and adjusted p-values.
  \item \code{adj_p_values}: Vector of adjusted p-values (for vector input).
  \item \code{posthoc_output_table}: Data frame with observed values, expected values,
        standardized residuals, and adjusted p-values (for vector input).
}
}
\description{
Performs a chi-squared test  \code{\link[stats]{chisq.test}}, then automatically conducts post-hoc analysis if the test is significant. The function provides adjusted p-values for each cell in the contingency table using a specified correction method.
}
\details{
The function first performs a chi-squared test using \code{\link[stats]{chisq.test}}. If the test is
significant (p < alpha) or if \code{force_posthoc = TRUE}, it conducts post-hoc analysis by examining
the standardized residuals. The p-values for these residuals are adjusted using the specified method
to control for multiple comparisons.

If the input is a data frame, the function attempts to convert it to a table and displays the
resulting table for verification.
}
\examples{
# Chi.square on independence: Association between two variables.
# Create a contingency table.
my_table <- as.table(rbind(c(100, 150, 50), c(120, 90, 40)))
dimnames(my_table) <- list(Gender = c("Male", "Female"),
                           Response = c("Agree", "Neutral", "Disagree"))

# Perform chi-squared test with post-hoc analysis.
f_chisq_test(my_table)

# Use a different adjustment method.
f_chisq_test(my_table, method = "holm")

# Other forms still work like Goodness-of-Fit: Match to theoretical distribution.
# Observed frequencies of rolling with a die 1 - 6.
observed <- c(2, 2, 10, 20, 15, 11)

# Expected probabilities under a fair die.
expected_probs <- rep(1/6, 6)

# Chi-Square Goodness-of-Fit Test.
f_chisq_test(x = observed, p = expected_probs)

}
\references{
This function implements a post-hoc analysis for chi-squared tests inspired by the methodology in:

Beasley, T. M., & Schumacker, R. E. (1995). Multiple Regression Approach to Analyzing Contingency Tables: Post Hoc and Planned Comparison Procedures. The Journal of Experimental Education, 64(1), 79-93.

The implementation draws inspiration from the \href{https://CRAN.R-project.org/package=chisq.posthoc.test}{'chisq.posthoc.test'} package by Daniel Ebbert.
}
\author{
Sander H. van Delden  \email{plantmind@proton.me} \cr
}
