% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bivRegion.R
\name{bivRegion}
\alias{bivRegion}
\title{Bivariate reference region estimation}
\usage{
bivRegion(
  Y = fit,
  H_choice = "Hcov",
  tau = 0.95,
  k = 20,
  display_plot = TRUE,
  shape = NULL,
  ...
)
}
\arguments{
\item{Y}{A set of bivariate data points, or a bivRegr object.}

\item{H_choice}{Kernel bandwidth selection method: "plug.in" for plug.in method,
"LSCV" for least squate cross valiation, "SCV" for smooth cross validation,
and "Hcov" for a bandwidth selection method which optimize the region coverage.}

\item{tau}{A number or vector defining the desired coverage(s) of the bivariate
reference region.}

\item{k}{In case of using "Hcov" the number of k fold cross validations
replicates to be performed.}

\item{display_plot}{A logical indicating if plot must be displayed during "Hcov"
bandwidht estimation procedure. The plot depicts region's coverage, evaluated
with k fold cross validation, depending on kernel bandwidth value.}

\item{shape}{Shape parameter modulating the final shape of the bivariate
probabilistic/reference region by hand.}

\item{...}{Additional parameters to be modified in KernSmooth::bkde2D()
function by the user (e.g. gridsize).}
}
\value{
This function return a region or a set of regions containing a given
percentage of bivariate data points.
}
\description{
This functions estimate a probabilistic/reference region for bivariate data. It is
based on a kernel density estimation. It may be applied to a
set of bivariate data points, or to a bivRegr object. In the former case, the
function will estimate a bivariate reference region for the model standarized
residuals.
}
\examples{
Y <- cbind(rnorm(100), rnorm(100))
Y <- as.data.frame(Y)
names(Y) <- c("y1", "y2")
region <- bivRegion(Y, tau = 0.95, shape = 2)
plot(region)
}
\references{
Duong, T. (2019) ks: Kernel Smoothing. R package version 1.11.6. https://CRAN.R--project.org/package=ks.

Matt Wand (2020). KernSmooth: Functions for Kernel Smoothing Supporting Wand & Jones (1995). R package version 2.23--18. https://CRAN.R--project.org/package=KernSmooth
}
