% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/partisan.R
\name{part_dil_asym}
\alias{part_dil_asym}
\title{Calculate Dilution Asymmetry}
\usage{
part_dil_asym(plans, shp, dvote, rvote)
}
\arguments{
\item{plans}{A \code{redist_plans} object or plans_matrix where each row indicates a district assignment and each column is a plan.}

\item{shp}{A \code{redist_map} object, tibble, or data frame containing other columns.}

\item{dvote}{Unqouted name of column in \code{shp} with total population.}

\item{rvote}{Unqouted name of column in \code{shp} with group population.}
}
\value{
A numeric vector. Can be shaped into a district-by-plan matrix.
}
\description{
Calculate Dilution Asymmetry
}
\examples{
data(nh)
data(nh_m)
# For a single plan:
part_dil_asym(plans = nh$r_2020, shp = nh, rvote = nrv, dvote = ndv)

# Or many plans:
part_dil_asym(plans = nh_m[, 3:5], shp = nh, rvote = nrv, dvote = ndv)

}
\references{
Sanford C. Gordon and Sidak Yntiso. 2024.
Base Rate Neglect and the Diagnosis of Partisan Gerrymanders.
Election Law Journal: Rules, Politics, and Policy. \doi{10.1089/elj.2023.0005}.
}
\concept{partisan}
