% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compactness.R
\name{comp_polsby}
\alias{comp_polsby}
\title{Calculate Polsby Popper Compactness}
\usage{
comp_polsby(
  plans,
  shp,
  use_Rcpp,
  perim_path,
  perim_df,
  epsg = 3857,
  ncores = 1
)
}
\arguments{
\item{plans}{A \code{redist_plans} object or plans_matrix where each row indicates a district assignment and each column is a plan.}

\item{shp}{A \code{redist_map} object, tibble, or data frame with an \code{sf} geometry column.}

\item{use_Rcpp}{If \code{TRUE} (the default for more than 8 plans), precompute boundaries
shared by each pair of units and use them to quickly compute the compactness score.}

\item{perim_path}{Path to perimeter tibble saved by \code{prep_perims()}}

\item{perim_df}{Tibble of perimeters from \code{prep_perims()}}

\item{epsg}{Numeric EPSG code to use to project the shapefile, if needed. Default is 3857.}

\item{ncores}{Integer number of cores to use. Default is 1.}
}
\value{
A numeric vector. Can be shaped into a district-by-plan matrix.
}
\description{
Calculate Polsby Popper Compactness
}
\examples{
data(nh)
data(nh_m)
# For a single plan:
comp_polsby(plans = nh$r_2020, shp = nh)

# Or many plans:
comp_polsby(plans = nh_m[, 3:5], shp = nh)

}
\references{
Cox, E. 1927. A Method of Assigning Numerical and Percentage Values to the
Degree of Roundness of Sand Grains. Journal of Paleontology, 1(3), 179-183.

Polsby, Daniel D., and Robert D. Popper. 1991. “The Third Criterion:
Compactness as a procedural safeguard against partisan gerrymandering.”
Yale Law & Policy Review 9 (2): 301–353.
}
\concept{compactness}
