% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readHAC.R
\docType{package}
\name{readHAC-package}
\alias{readHAC-package}
\title{Read acoustic HAC raw data}
\description{
The HAC data format is a binary format containing so-called \code{tuples}.
A tuple can hold various sorts of information depending on the tuple type.
For instance tuples exist to specify positions, echosounder information and
acoustic signal data etc.
This R package can read, write and subset the HAC data format.
}
\details{
See the description of the ICES HAC standard data exchange format,
version 1.60.
}
\examples{
require(readHAC)

######################################################################
## Example file
hacfile <- system.file("hac", "Hac-test_000001.hac", package="readHAC")

######################################################################
## Step 1. Read hac data into R
hac <- readHAC(hacfile)
print(hac)

######################################################################
## Step 2. Select sub-components
pingdata <- ( subset(hac, softwarechannel==3 & type==10000) )
channel  <- ( subset(hac, softwarechannel==3 & type==9001 ) )
echosounder <- ( subset(hac, echosounder==channel$echosounder & type==901) )

######################################################################
## Step 3. Parse the binary data
print( parseHAC(pingdata) )
info <- parseHAC(channel)[5:7]
s <- ( parseHAC(pingdata)$"Sample value" )
s[s>0] <- NA  ## discard positive dB values
sec <- parseHAC(pingdata)$"Time CPU ANSI"; sec <- sec - min(sec)
flip <- function(x) t( x[nrow(x):1, ] )
image(sec, 1:nrow(s), flip(s), axes=FALSE, ylab="sample")
axis(1)
at <- seq(nrow(s), 1, by=-100)
axis(2, at=at, labels=nrow(s)-at)
box()
legend("topright", legend=paste(names(info), unlist(info)) )
}
\references{
McQuinn, Ian H., et al. Description of the ICES HAC standard
    data exchange format, version 1.60. Conseil international pour
    l'exploration de la mer, 2005.
    \url{http://biblio.uqar.ca/archives/30005500.pdf}
}

