% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/themes.R
\name{sunrise}
\alias{sunrise}
\title{Theme sunrise}
\usage{
sunrise(
  font_size = 15,
  font_color = "#8069ff",
  header_font_size = 15,
  header_font_color = "#8069ff",
  cell_padding = 6,
  centered = FALSE
)
}
\arguments{
\item{font_size}{Numeric value representing the size of the font within the table (in px).
Default is 15.}

\item{font_color}{Color of the font for the text within the table and the group headers.
Default is #8069ff.}

\item{header_font_size}{Numeric value representing the size of the font within the table (in px).
Default is 15.}

\item{header_font_color}{Color of the font for the header text.
Default is #8069ff.}

\item{cell_padding}{Numeric value representing the padding size between cells (in px).
Default is 6.}

\item{centered}{Logical: vertically center the contents of the table.
Default is FALSE.}
}
\value{
an object of class theme that is applied to a reactable table.
}
\description{
sunrise table theme
}
\examples{
data <- iris[10:29, ]

## Standard sunrise theme
reactable(data,
          theme = sunrise())

## Additional options applied
reactable(data,
          theme = sunrise(font_size = 12, font_color = "grey", cell_padding = 3))

}
