% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/themes.R
\name{sanfran}
\alias{sanfran}
\title{Theme sanfran}
\usage{
sanfran(
  font_size = 14,
  font_color = "#222222",
  header_font_size = 15,
  header_font_color = "#212121",
  cell_color = "#f5f5f5",
  cell_border_width = 6,
  cell_border_color = "#ffffff",
  cell_padding = 6,
  pagination_color = "#222222",
  centered = FALSE
)
}
\arguments{
\item{font_size}{Numeric value representing the size of the font within the table (in px).
Default is 14.}

\item{font_color}{Color of the font for the text within the table.
Default is #222222.}

\item{header_font_size}{Numeric value representing the size of the font within the table (in px).
Default is 15.}

\item{header_font_color}{Color of the font for the header text.
Default is transparent}

\item{cell_color}{Color of the background of the cells.
Default is #f5f5f5.}

\item{cell_border_width}{Numeric value representing the border width of the cells.
Default is 6.}

\item{cell_border_color}{Numeric value representing the border color of the cells.
Default is #ffffff.}

\item{cell_padding}{Numeric value representing the padding size between cells (in px).
Default is 6.}

\item{pagination_color}{Color of the pagination below the table.
Default is #222222.}

\item{centered}{Logical: vertically center the contents of the table.
Default is FALSE.}
}
\value{
an object of class theme that is applied to a reactable table.
}
\description{
San Francisco Chronicles-inspired table theme
}
\examples{
data <- iris[10:29, ]

## Standard void theme
reactable(data,
          theme = sanfran())

## Additional options applied
reactable(data,
          theme = sanfran(font_size = 12, font_color = "grey"))

}
