% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/react_spark.R
\name{react_sparkbar}
\alias{react_sparkbar}
\title{Add a sparkline bar chart to a reactable table}
\usage{
react_sparkbar(
  data,
  height = 22,
  fill_color = "slategray",
  fill_color_ref = NULL,
  fill_opacity = 1,
  outline_color = "transparent",
  outline_color_ref = NULL,
  outline_width = 1,
  highlight_bars = NULL,
  labels = "none",
  label_size = "0.8em",
  decimals = 0,
  max_value = NULL,
  min_value = NULL,
  statline = NULL,
  statline_color = "red",
  statline_label_size = "0.8em",
  bandline = NULL,
  bandline_color = "red",
  bandline_opacity = 0.2,
  tooltip = TRUE,
  tooltip_type = 1,
  tooltip_color = NULL,
  tooltip_size = "1.1em",
  margin = NULL
)
}
\arguments{
\item{data}{Dataset containing a column with numeric values in a list format.}

\item{height}{Height of the sparkbar.
Default is 22.}

\item{fill_color}{The color of the bar fill.
Default is slategray.}

\item{fill_color_ref}{Optionally assign fill colors from another column
by providing the name of the column containing the colors in quotes.
Only one color can be provided per row.
Default is NULL.}

\item{fill_opacity}{A value between 0 and 1 that adjusts the opacity.
A value of 0 is fully transparent, a value of 1 is fully opaque.
Default is 1.}

\item{outline_color}{The color of the outline around the filled bars.
Default is transparent.}

\item{outline_color_ref}{Optionally assign outline colors from another column
by providing the name of the column containing the colors in quotes.
Only one color can be provided per row.
Default is NULL.}

\item{outline_width}{Width of the outline around the filled bars.
Default is 1.}

\item{highlight_bars}{Use `highlight_bars()` to assign colors to particular bars.
Colors can be assigned to all, min, max, first, or last bars.
By default, transparent colors are assigned to each bars.}

\item{labels}{Show labels for points of interest.
Options are 'min', 'max', 'first', 'last', 'all', or 'none'.
Default is 'none'.}

\item{label_size}{The size of the labels.
Default is 0.8em.}

\item{decimals}{Numeric: The number of decimals displayed in the labels and tooltip.
Default is 0.}

\item{max_value}{Numeric: the maximum value of the sparkline range.
Default is NULL (automatically the maximum value of each sparkline series).}

\item{min_value}{Numeric: the minimum value of the sparkline range.
Default is NULL (automatically the minimum value of each sparkline series).}

\item{statline}{Inserts a horizontal dotted line representing a statistic,
and places the value of that statistic to the right of the line.
Options are 'mean', 'median', 'min', or 'max'.
Default is NULL.}

\item{statline_color}{The color of the horizontal dotted statline.
Default is red.}

\item{statline_label_size}{The size of the label to the right of the statline.
Default is 0.8em.}

\item{bandline}{Inserts a horizontal bandline to render ranges of interest.
Options are 'innerquartiles' or 'range' (min to max).
Default is NULL.}

\item{bandline_color}{The color of the bandline.
Default is red.}

\item{bandline_opacity}{A value between 0 and 1 that adjusts the opacity.
A value of 0 is fully transparent, a value of 1 is fully opaque.
Default is 0.2.}

\item{tooltip}{Logical: turn the tooltip on or off.
Default is TRUE.}

\item{tooltip_type}{The tooltip type.
Options are 1 or 2.
Default is 1.}

\item{tooltip_color}{The color of the tooltip labels.
Default is NULL.}

\item{tooltip_size}{The size of the tooltip labels.
Default is '1.1em'.}

\item{margin}{The four-sided margin around the sparkbar.
Use margin() to assign the top, right, bottom, and left margins.}
}
\value{
a function that creates a sparkline bar chart
    from a column containing a list of values.
}
\description{
The `react_sparkbar()` function utilizes the {dataui} package <https://github.com/timelyportfolio/dataui> to create an interactive sparkline bar chart.
    The data provided must be in a list format.
    The vertical height of the sparkbar can be adjusted with `height`. By default, the height is matched to the height of a cell in a reactable table. However, the height can be increased to better see the patterns in the data.
    The four-sided margin around the sparkbar can be controlled with `margin()`. When labels are added to the sparkbars, the margin will auto-adjust (in most instances) to be able to display those labels.
    If the labels contain large values or values with many digits, the left and right margins may need to be increased slightly for the full numbers to be visible.
    The fill color and fill width can be controlled with `fill_color`, `fill_color_ref`, and `fill_opacity`.
    The outline color and width of the filled bars can be controlled with `outline_color`, `outline_color_ref`, and `outline_width`.
    `statline` can be used to show a horizontal dotted line that represents either the mean, median, min, or max (your choice).
    The appearance of the statline and statline labels can be controlled with `statline_color` and `statline_label_size`.
    A bandline can be added by using `bandline`. The options are innerquartiles which highlights the innerquartiles of the data or range which highlights the full range of the data.
    By default, `react_sparkbar()` is interactive and data points will be shown when hovering over the sparkbars. This can be turned off by setting `tooltip` to FALSE.
    There are two tooltip types available within `tooltip_type`. The size and color of the tooltip labels can be adjusted with `tooltip_size` and `tooltip_color`.
    Also by default, there are no labels on the bars themselves. However, one could add labels to the first, last, min, max, or all values within `labels`.
    The labels that are shown on the sparkbar and in the tooltip are automatically rounded to the nearest whole integer. But decimals can be shown by providing the number of decimal places in `decimals`.
    The minimum value of a data series is the minimum value shown for a sparkbar, but this can be adjusted with `min_value` and the max can be adjusted with `max_value`.
    `react_sparkline()` should be placed within the cell argument in reactable::colDef.
}
\examples{
\dontrun{
library(dplyr)
## Default sparkline bar chart
iris \%>\%
 group_by(Species) \%>\%
 summarize(sepal_length = list(Sepal.Length)) \%>\%
 reactable(.,
 columns = list(sepal_length = colDef(cell = react_sparkbar(.))))

## Highlight particular bars
iris \%>\%
 group_by(Species) \%>\%
 summarize(sepal_length = list(Sepal.Length)) \%>\%
 reactable(.,
 columns = list(sepal_length = colDef(cell = react_sparkbar(.,
 decimals = 1,
 min_value = 0,
 highlight_bars = highlight_bars(min="red",max="blue")))))

## Conditionally assign fill colors to groups
iris \%>\%
 group_by(Species) \%>\%
 summarize(sepal_length = list(Sepal.Length)) \%>\%
 mutate(flower_cols = case_when(
   Species == "setosa" ~ "purple",
   Species == "versicolor" ~ "darkgreen",
   Species == "virginica" ~ "orange",
   TRUE ~ "grey"
 )) \%>\%
 reactable(.,
 columns = list(flower_cols = colDef(show=FALSE),
 sepal_length = colDef(cell = react_sparkbar(.,
 height = 80,
 fill_color_ref = "flower_cols"))))

## Add labels to particular bars
iris \%>\%
 group_by(Species) \%>\%
 summarize(sepal_length = list(Sepal.Length)) \%>\%
 reactable(.,
 columns = list(sepal_length = colDef(cell = react_sparkbar(.,
 height = 80,
 decimals = 1,
 highlight_bars = highlight_bars(first="blue",last="red"),
 labels = c("first","last")))))

## Add statline to show the mean for each sparkbar
iris \%>\%
 group_by(Species) \%>\%
 summarize(sepal_length = list(Sepal.Length)) \%>\%
 reactable(.,
 columns = list(sepal_length = colDef(cell = react_sparkbar(.,
 height = 80,
 decimals = 1,
 statline = "mean"))))

## Combine multiple elements together
iris \%>\%
 group_by(Species) \%>\%
 summarize(sepal_length = list(Sepal.Length)) \%>\%
 reactable(.,
 columns = list(sepal_length = colDef(cell = react_sparkbar(.,
 height = 80,
 decimals = 1,
 statline = "mean",
 bandline = "innerquartiles"))))
}
}
