% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/embed_img.R
\name{embed_img}
\alias{embed_img}
\title{Embed image from web to cells in a column}
\usage{
embed_img(
  data,
  height = 24,
  width = 24,
  horizontal_align = "center",
  label = NULL,
  label_position = "right"
)
}
\arguments{
\item{data}{Dataset containing URL's to images}

\item{height}{A value given for the height of the image in px.
Default height is 24px.}

\item{width}{A value given for the width of the image in px.
Default width is 24px.}

\item{horizontal_align}{The horizontal alignment of the image within a cell.
Options are "left", "right", or "center".
Default is "center".}

\item{label}{Optionally assign a label to the image from another column.
Default is set to NULL or no label.}

\item{label_position}{Position of label relative to image.
Options are "right", "left", "below", or "above".
Default is right.}
}
\value{
a function that renders an image
    to a column containing a valid web link.
}
\description{
The `embed_img()` function adds images obtained from the web to a column within reactable.
    It should be placed within the cell argument in reactable::colDef.
}
\examples{
## If no image links are in the original dataset, you need to assign them like so:
library(dplyr)
data <- iris \%>\%
 mutate(
 img = case_when(
 Species == "setosa" ~
 "https://upload.wikimedia.org/wikipedia/commons/d/d9/Wild_iris_flower_iris_setosa.jpg",
 Species == "versicolor" ~
 "https://upload.wikimedia.org/wikipedia/commons/7/7a/Iris_versicolor.jpg",
 Species == "virginica" ~
 "https://upload.wikimedia.org/wikipedia/commons/9/9f/Iris_virginica.jpg",
 TRUE ~ "NA"))

## Then use embed_img() to display images
reactable(data,
columns = list(
 img = colDef(cell = embed_img())))

## By default, images are given a size of 24px by 24px,
## but you can adjust the size using height and width:
reactable(data,
columns = list(
 img = colDef(cell = embed_img(height = 50, width = 45))))

## Optionally assign a label to the image from another column
reactable(data,
columns = list(
 img = colDef(cell = embed_img(data, label = "Species"))))

}
