% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/table_elements.R
\name{add_icon_legend}
\alias{add_icon_legend}
\title{Add an icon legend to a reactable table}
\usage{
add_icon_legend(
  table = NULL,
  icon_set = NULL,
  show_labels = TRUE,
  labels = NULL,
  align = "right",
  title = NULL,
  footer = NULL,
  margin = NULL
)
}
\arguments{
\item{table}{A reactable table.}

\item{icon_set}{The icon set to be displayed in the legend.
Options are "ski rating", "medals", and "batteries".
Default is NULL.}

\item{show_labels}{Logical. Show or hide the labels next to the legend.
Default is TRUE.}

\item{labels}{Assign label to each icon in the specified icon set.
Number of labels must match the number of icons in the icon set.
Default is NULL.}

\item{align}{The horizontal alignment of the legend.
Options are 'left' or 'right'.
Default is 'right'.}

\item{title}{The title above the legend.
Default is NULL.}

\item{footer}{The footer below the legend.
Default is NULL.}

\item{margin}{Use margin() to set the margin around the legend (top, right, bottom, left).
Default is NULL.}
}
\value{
a function that adds a source below a reactable table.
}
\description{
Use `add_icon_legend()` to place a legend below a reactable table.
     The legend can be used to display the icon set used within `icon_sets()`.
     The legend can be aligned to the right or left of the table.
     Custom labels can be applied to the upper and lower bounds of the legend.
}
\examples{
\dontrun{
## Create the reactable table and then pipe in the legend
library(dplyr)
data <- iris[10:29, ]
table <- reactable(data,
columns = list(Petal.Length = colDef(
cell = icon_sets(data, icon_set = "medals"))))

table \%>\%
  add_icon_legend(icon_set = "medals")

## The legend can be aligned to the left or right of the table
table \%>\%
  add_icon_legend(icon_set = "medals", align = "left")

## Add custom labels to each icon in the legend
table \%>\%
  add_icon_legend(icon_set = "medals", labels = c("Shortest Length","Avg Length","Longest Length"))

## Add a title and footer to the legend
table \%>\%
  add_icon_legend(icon_set = "medals", title = "Icon Legend Title", footer = "Icon Legend Footer")
}
}
