% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_GRASS.R
\name{plot_GRASS}
\alias{plot_GRASS}
\title{A function to plot a raster from the current GRASS mapset}
\usage{
plot_GRASS(x, colours, out_x, ...)
}
\arguments{
\item{x}{The name of an object in the current GRASS mapset.}

\item{colours}{Optional. A colour scale. If not supplied, the default settings in \code{plot.stars} is used. If supplied, \code{length(colours)} must be less than or equal to the number of unique values in the raster.}

\item{out_x}{Optional. If supplied, the function makes a call to \code{\link{retrieve_raster}} and writes out the raster to the file path \code{out_x}. Otherwise the function will write the layer to \code{tempdir}.}

\item{...}{Additional arguments to \code{plot.stars}.}
}
\value{
Nothing.
}
\description{
Given the name of a raster in the current GRASS mapset, this function will plot it as a \code{stars} object.
}
\examples{
# Will only run if GRASS is running
# You should load rdwplus and initialise GRASS via the initGRASS function
if(check_running()){

# Load data set
dem <- system.file("extdata", "dem.tif", package = "rdwplus")

# Set environment 
set_envir(dem)

# Plot
plot_GRASS("dem.tif") # argument must match name of data set in the mapset
plot_GRASS("dem.tif", heat.colors(10)) # with different colour scale

}
}
