% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diversity-components.R
\name{raw_rho}
\alias{raw_rho}
\title{Raw rho (low level diversity component)}
\usage{
raw_rho(meta)
}
\arguments{
\item{meta}{object of class \code{metacommunity}}
}
\value{
\code{raw_rho} returns an object of class \code{powermean}
}
\description{
Calculates the low-level diversity component necessary for calculating raw rho
diversity.
}
\details{
Values generated from \code{raw_rho()} may be input into \code{subdiv()} and
\code{metadiv()} to calculate raw subcommunity and metacommunity rho
diversity.
}
\examples{
pop <- data.frame(a = c(1,3), b = c(1,1))
row.names(pop) <- paste0("sp", 1:2)
pop <- pop/sum(pop)
meta <- metacommunity(pop)

# Calculate raw rho component
r <- raw_rho(meta)
subdiv(r, 1)
metadiv(r, 1)

}
\references{
R. Reeve, T. Leinster, C. Cobbold, J. Thompson, N. Brummitt,
S. Mitchell, and L. Matthews. 2016. How to partition diversity.
arXiv 1404.6520v3:1–9.
}
