% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/power_mean.R
\name{power_mean}
\alias{power_mean}
\title{Power mean of vector elements}
\usage{
power_mean(values, order = 1, weights = rep(1, length(values)))
}
\arguments{
\item{values}{Values for which to calculate mean.}

\item{order}{Order of power mean.}

\item{weights}{Weights of elements, normalised to 1 inside function.}
}
\value{
Weighted power mean
}
\description{
\code{power_mean()} calculates the power mean of a set of values.
}
\details{
Calculates the order-th power mean of a single
set of non-negative values, weighted by weights; by default, weights are
equal and order is 1, so this is just the arithmetic mean. Equal weights
and a order of 0 gives the geometric mean, and an order of -1 gives the
harmonic mean.
}
\examples{
values <- sample(1:50, 5)
power_mean(values)

}
