% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/variables.R
\name{ddi_varGrp}
\alias{ddi_varGrp}
\alias{ddi_defntn}
\title{varGrp and its child nodes}
\usage{
ddi_varGrp(...)

ddi_defntn(...)
}
\arguments{
\item{...}{Child nodes or attributes.}
}
\value{
A ddi_node object.
}
\description{
A group of variables that may share a common subject, arise from the
interpretation of a single question, or are linked by some other factor.
Variable groups are created this way in order to permit variables to belong
to multiple groups, including multiple subject groups such as a group of
variables on sex and income, or to a subject and a multiple response group,
without causing overlapping groups. Variables that are linked by use of the
same question need not be identified by a Variable Group element because they
are linked by a common unique question identifier in the Variable element.
Note that as a result of the strict sequencing required by XML, all Variable
Groups must be marked up before the Variable element is opened. That is, the
mark-up author cannot mark up a Variable Group, then mark up its constituent
variables, then mark up another Variable Group. More information on these
elements, especially their allowed attributes, can be found in the
references.
}
\details{
\emph{Parent nodes}

\code{varGrp} is contained in \code{dataDscr}.

\emph{varGrp specific child nodes}
\itemize{
\item \code{ddi_defntn()} is the rationale for why the variable group was constituted.
}
}
\section{Shared and complex child nodes}{

\itemize{
\item \code{\link[=ddi_concept]{ddi_concept()}}
\item \code{\link[=ddi_labl]{ddi_labl()}}
\item \code{\link[=ddi_notes]{ddi_notes()}}
\item \code{\link[=ddi_txt]{ddi_txt()}}
\item \code{\link[=ddi_universe]{ddi_universe()}}
}
}

\examples{
ddi_varGrp()

# Functions that need to be wrapped in ddi_varGrp()

ddi_defntn("The following eight variables were only asked in Ghana.")

}
\references{
\href{https://ddialliance.org/Specification/DDI-Codebook/2.5/XMLSchema/field_level_documentation_files/schemas/codebook_xsd/elements/varGrp.html}{varGrp documentation}

\href{https://ddialliance.org/Specification/DDI-Codebook/2.5/XMLSchema/field_level_documentation_files/schemas/codebook_xsd/elements/defntn.html}{defntn documentation}
}
