% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stdyInfo.R
\name{ddi_qualityStatement}
\alias{ddi_qualityStatement}
\alias{ddi_otherQualityStatement}
\title{qualityStatement and its child nodes}
\usage{
ddi_qualityStatement(...)

ddi_otherQualityStatement(...)
}
\arguments{
\item{...}{Child nodes or attributes.}
}
\value{
A ddi_node object.
}
\description{
The Quality Statement consists of two parts, standardsCompliance and
otherQualityStatement. In standardsCompliance list all specific standards
complied with during the execution of this study. Note the standard name and
producer and how the study complied with the standard. More information on
these elements, especially their allowed attributes, can be found in the
references.
}
\details{
\emph{Parent nodes}

\code{qualiyStatement} is contained in \code{stdyInfo}.

\emph{qualityStatement specific child nodes}
\itemize{
\item \code{ddi_otherQualityStatement()} holds additional quality statements.
}
}
\section{Shared and complex child nodes}{

\itemize{
\item \code{\link[=ddi_standardsCompliance]{ddi_standardsCompliance()}}
}
}

\examples{
ddi_qualityStatement()

# Functions that need to be wrapped in ddi_qualityStatement()

ddi_otherQualityStatement("Additional quality statements not addressed in standardsCompliance.")

}
\references{
\href{https://ddialliance.org/Specification/DDI-Codebook/2.5/XMLSchema/field_level_documentation_files/schemas/codebook_xsd/elements/qualityStatement.html}{qualityStatement documentation}

\href{https://ddialliance.org/Specification/DDI-Codebook/2.5/XMLSchema/field_level_documentation_files/schemas/codebook_xsd/elements/otherQualityStatement.html}{otherQualityStatement documentation}
}
