% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stdyInfo.R
\name{ddi_polygon}
\alias{ddi_polygon}
\title{polygon and its child nodes}
\usage{
ddi_polygon(...)
}
\arguments{
\item{...}{Child nodes or attributes.}
}
\value{
A ddi_node object.
}
\description{
The minimum polygon that covers a geographical area, and is delimited by at
least 4 points (3 sides), in which the last point coincides with the first
point.More information on these elements, especially their allowed
attributes, can be found in the references.
}
\details{
\emph{Parent nodes}

\code{polygon} is contained in \code{boundPoly}.
}
\section{Shared and complex child nodes}{

\itemize{
\item \code{\link[=ddi_point]{ddi_point()}}
}
}

\examples{
# ddi_polygon requires ddi_point() which requires ddi_gringLat() and ddi_gringLon()
ddi_polygon(ddi_point(
               ddi_gringLat("42.002207"), 
               ddi_gringLon("-120.005729004")
             )
           )
           
}
\references{
\href{https://ddialliance.org/Specification/DDI-Codebook/2.5/XMLSchema/field_level_documentation_files/schemas/codebook_xsd/elements/polygon.html}{polygon documentation}
}
