% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/method.R
\name{ddi_anlyInfo}
\alias{ddi_anlyInfo}
\alias{ddi_dataAppr}
\alias{ddi_EstSmpErr}
\alias{ddi_respRate}
\title{anlyInfo and its child nodes}
\usage{
ddi_anlyInfo(...)

ddi_dataAppr(...)

ddi_EstSmpErr(...)

ddi_respRate(...)
}
\arguments{
\item{...}{Child nodes or attributes.}
}
\value{
A ddi_node object.
}
\description{
Information on data appraisal.
}
\details{
\emph{Parent nodes}

\code{anlyInfo} is contained in \code{method}.

\emph{anlyInfo specific child nodes}
\itemize{
\item \code{ddi_dataAppr()} are other issues pertaining to data appraisal. Describe
here issues such as response variance, nonresponse rate and testing for bias,
interviewer and response bias, confidence levels, question bias, etc.
Attribute type allows for optional typing of data appraisal processes and
option for controlled vocabulary.
\item \code{ddi_EstSmpErr()} are estimates of sampling error. This element is a
measure of how precisely one can estimate a population value from a given
sample.
\item \code{ddi_respRate()} is the response rate. The percentage of sample members
who provided information. This may include a broader description of
stratified response rates, information affecting response rates etc.
}
}
\examples{
ddi_anlyInfo()

# Functions that need to be wrapped in ddi_anlyInfo()

ddi_dataAppr("These data files were obtained from the United States House of 
             Representatives, who received them from the Census Bureau 
             accompanied by the following caveats...")

ddi_EstSmpErr("To assist NES analysts, the PC SUDAAN program was used to 
              compute sampling errors for a wide-ranging example set of 
              proportions estimated from the 1996 NES Pre-election Survey 
              dataset...")

ddi_respRate("For 1993, the estimated inclusion rate for TEDS-eligible 
             providers was 91 percent, with the inclusion rate for all 
             treatment providers estimated at 76 percent (including privately 
             and publicly funded providers).")

}
\references{
\href{https://ddialliance.org/Specification/DDI-Codebook/2.5/XMLSchema/field_level_documentation_files/schemas/codebook_xsd/elements/anlyInfo.html}{anlyInfo documentation}

\href{https://ddialliance.org/Specification/DDI-Codebook/2.5/XMLSchema/field_level_documentation_files/schemas/codebook_xsd/elements/dataAppr.html}{dataAppr documentation}

\href{https://ddialliance.org/Specification/DDI-Codebook/2.5/XMLSchema/field_level_documentation_files/schemas/codebook_xsd/elements/respRate.html}{respRate documentation}

\href{https://ddialliance.org/Specification/DDI-Codebook/2.5/XMLSchema/field_level_documentation_files/schemas/codebook_xsd/elements/EstSmpErr.html}{EstSmpErr documentation}
}
