% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_climate.R
\name{generate_climate}
\alias{generate_climate}
\title{Generate climate dataset}
\usage{
generate_climate(
  x,
  y,
  tz,
  era5land_hour,
  era5land_month,
  daytime_start = 7,
  daytime_end = 19
)
}
\arguments{
\item{x}{num. Longitude in UTM. Can be obtained from the location name with
\code{\link[nominatimlite:geo_lite_sf]{nominatimlite::geo_lite_sf()}}.}

\item{y}{num. Latitude in UTM. Can be obtained from the location name with
\code{\link[nominatimlite:geo_lite_sf]{nominatimlite::geo_lite_sf()}}.}

\item{tz}{num. Time zone. Can be obtained from the coordinates with
\code{\link[lutz:tz_lookup_coords]{lutz::tz_lookup_coords()}}.}

\item{era5land_hour}{str. Path to ERA5 land data monthly averaged reanalysis
by hour of day in netCDF. See the corresponding vignette
\code{vignette("climate", package = "rcontroll")} to download corresponding
data from Copernicus in R.}

\item{era5land_month}{str. Path to ERA5 land data monthly averaged reanalysis
in netCDF. See the corresponding vignette \code{vignette("climate", package
  = "rcontroll")} to download corresponding data from Copernicus in R.}

\item{daytime_start}{int. Daytime starting hour to compute nigh and day
variables (default 7).}

\item{daytime_end}{int. Daytime ending hour to compute nigh and day variables
(default 19).}
}
\value{
A list with two \code{\link[=data.frame]{data.frame()}}: daytimevar and climatedaytime12.
}
\description{
\code{TROLL} forest simulator relies on climate tables with half-hourly variations
of a typical day and monthly variations of a typical year which are recycled
through simulation days and years. Initially, \code{TROLL} climate tables were
computed from the Nouraflux dataset. Variations in quantities of interests
(temperatures, ...) were averaged to the target resolution (half-hour for
daily variation or month for monthly variation). The purpose of climate
generation functions is to compute equivalent climate tables from the ERA5
land reanalysis dataset (Muñoz-Sabater et al. 2021). With these functions,
\code{rcontroll} users only need inventories and associated functional traits to
run \code{TROLL} simulations. See the corresponding vignette
\code{vignette("climate", package = "rcontroll")} for further details.
}
\details{
The \code{TROLL} forest model simulates tree growth based on ecophysiological
processes, with an external climate forcing. Input climatic conditions are
provided in the form of climate tables with (i) half-hourly standardised
variation of a typical day, and (ii) monthly average values of a typical
year, which are currently recycled through simulation. Initially, TROLL
climate tables were computed from the Nouraflux dataset (Poncy et al., 1998).
The variation in quantities of interest (irradiance, temperature, vapour
pressure, rainfall, and wind speed) were averaged to the target resolution
(half-hour for daily variation or month for monthly variation).

The purpose of the climate generation function is to compute equivalent
climate tables from a global climatic reanalysis dataset. With
\code{generate_climate}, \code{rcontroll} users no longer need to format complex
climate input fields, but can generate them from global and carefully
documented climate distributions to run \code{TROLL} simulations. The selected
input climate product for this version of \code{rcontroll} is ERA5-Land
(Muñoz-Sabater et al. 2021). The ERA5-Land climate reanalysis has two main
advantages over other climate reanalysis products: (1) the data are at a
spatial resolution of 9km and have been available at hourly temporal
resolution since 1950, and (2) daily or monthly averages are available and
their uncertainties are reported.
\subsection{Hypotheses}{

The following assumptions are made in the generation of climate data:
\enumerate{
\item The temperature at 2m and its derivatives (\code{d2m}) from ERA5-land
corresponds to air temperature measurement used as an input in \code{TROLL};
\item We can calculate the  vapour pressure deficit using the Buck equation;
\item The extraction of standardised half-hourly values of an average day and of
monthly average values of a year for the climate variables of interest is
based on the decomposition of the raw time series into: (i) an overall trend
over the study period, (ii) seasonal or daily variation across months or
hours depending on the study level, and (iii) the remaining variation;
\item Half-hourly values are not available for ERA5-land data. Spline functions
are used to interpolate hourly values for downscaling to half-hourly
resolution.
}
}

\subsection{Quantities of interest}{
\subsection{\code{TROLL} variables}{

TROLL climate tables summarise temporal variation of quantities of interest.
These variations are called \strong{seasonal pattern} and are computed from time
series under the additive assumption :

\eqn{X(t) = Trend_X(t)+Seasonal_{x,Period}(t  \mod p [mod Period]) +
Irregular(t)}

With :
\itemize{
\item \eqn{Trend_X(t)} a moving average covering one period;
\item \eqn{Seasonal_{x,Period}(t  \mod p [mod Period])} the seasonal pattern
contribution at t time modulo the period;
\item \eqn{Irregular(t)} the remainder part.
}

The de-seasonally average of X is defined as :

\eqn{mean(X)=mean(Trend_X(t))}

These values of seasonal pattern and de-seasonally average are used to
compute the climate table \link{TROLLv3_climatedaytime12} and
\link{TROLLv3_daytimevar}.
}

\subsection{ERA5-Land variables}{

There is a restricted set of variables needed to generate the TROLL climate
files:
\itemize{
\item t2m: Temperature at 2m in K
\item d2m: Dew point temperature at 2m in K
\item tp: Cumulative rainfall in m
\item sp: Atmospheric pressure at the surface in Pa
\item ssrd: Cumulative Net solar irradiation in J/m2
\item u10: Zonal wind component at 10m in m/s
\item v10: Meridional wind component at 10m in m/s
}
}

}

\subsection{Calculation of variables}{

The transition from ERA-Land data to \code{TROLL} data requires several
transformations. The \code{TROLL} climate files correspond to seasonal components,
either daily from 7am to 7pm, or monthly. The extraction of these seasonal
components is possible by analysing the time series of the data. An additive
decomposition of the variables allows one to obtain the pattern of interest
at the original resolution (hourly or monthly). Interpolation of the pattern
using spline functions of the periodic type, ensuring the boundary conditions
(i.e. value at 0 am is the same as 12 pm), except for the \code{ssrd} which is not
a continuous periodic function and which requires natural type spline
interpolation. An evaluation of the quality of the pattern extraction is
possible by measuring the standard deviation of the error to the original
time series. This error can be calculated for each unit of the pattern (for
each hour for example).
\subsection{Wind speed}{

The wind speed is the norm of the vector generated by the u10 and v10
components of the wind. We can therefore deduce that the wind speed
corresponds to:

\eqn{WindSpeed= \sqrt{u10^2+v10^2}}
}

\subsection{Vapour pressure deficit}{

The calculation of the vapour pressure deficit can be done according to three
variables (\code{t2m}, \code{d2m} and \code{sp}) using the formula of (Buck 1981):

\eqn{VPD =e_{sat}(d2m,sp)-e_{obst}(2m,sp)}

\eqn{e_*(t2m|d2m,sp)=611.21xf(t2m|d2m,sp)x(1)}

\eqn{(1)=18.678-(t2m|d2m-273.15)/234.5x(t2m|d2m-273.15)/
(240.97+t2m|d2m-273.15)}

\eqn{f(t2m|d2m,sp)=1.0007+10^{-7}xspx0.032+5.9x10^{-6}x(t2m|d2m-273.15)^2}
}

\subsection{Instantaneous irradiance}{

The measurement of irradiance in the ERA5 data corresponds to the
accumulation either at hourly or daily intervals. The instantaneous
measurement can be obtained by calculating the variation of this
accumulation:

\eqn{\Delta ssrd(t)= ssrd(t)-ssrd(t-1)}
}

}

\subsection{Conclusion}{

In conclusion, despite some discrepancies between climate input generated
from local meteorological station data and the \code{generate_climate} function
that should be investigated further, the \code{generate_climate} function allows
\code{rcontroll} users to easily obtain relevant climate data for their study. The
discrepancies may be partly due to the unconventional situation of the
Nouraflux station, which should not be considered as the true climate.

\strong{Warning}: As \code{TROLL} is under constant development, some of the variables
presented here may not be used in the current version (v 3.1.7) and may be
left over from previous versions or may be intended for future versions.
Furthermore, this supplementary information corresponds to the version 3.1.7
of \code{TROLL} and the climate variables used by the model may change as new
versions of \code{TROLL} are released. We plan to include future major
developments of \code{TROLL} in \code{rcontroll} to keep the advances of the model
accessible to the community, including the development of the
\code{generate_climate} function. We thus invite the reader to check the
corresponding updated vignette on GitHub
(https://sylvainschmitt.github.io/rcontroll/articles/climate.html) according
to the version of \code{TROLL} they are using in \code{rcontroll} (check with
\code{\link[=TROLL.version]{TROLL.version()}}).
}

\subsection{References}{

Buck, Arden L. (1981) New equations for computing vapor pressure and
enhancement factor. Journal of Applied Meteorology and Climatology, 1981,
vol. 20, no 12, p. 1527-1532.

Muñoz-Sabater, J., Dutra, E., Agustí-Panareda, A., Albergel, C., Arduini, G.,
Balsamo, G., … Thépaut, J. N. (2021). ERA5-Land: A state-of-the-art global
reanalysis dataset for land applications. Earth System Science Data, 13(9),
4349–4383. https://doi.org/10.5194/essd-13-4349-2021

Poncy, O., Riéra, B., Larpin, D., Belbenoit, P., Jullien, M., Hoff, M., &
Charles-Dominique, P. (1998). The permanent field research station “Les
Nouragues” in the tropical rainforest of French Guiana: current projects and
preliminary results on tree diversity, structure, and dynamics. Forest
Biodiversity in North, Central and South America, and the Caribbean: Research
and Monitoring., 385–410.
}
}
