#' Multiple Sources of Attentional Dysfunction in Adults With Tourette’s
#' Syndrome
#'
#' @description
#' Data from a psychological study comparing attentional performances of
#' Tourette’s syndrome (TS) patients, ADHD patients, and controls. These data
#' were simulated using the sufficient statistics from Silverstein et al.
#' (1995).
#'
#' @format A data frame with 51 rows and 2 columns:
#'
#' \describe{
#'   \item{\code{accuracy}}{(numeric) Participant's accuracy in the attentional
#'   task}
#'   \item{\code{group}}{(factor) Participant's group membership (TS patient,
#'   ADHD patient, or control).}
#'  }
#'
#' @references Silverstein, S. M., Como, P. G., Palumbo, D. R., West, L. L.,
#' & Osborn, L. M. (1995). Multiple sources of attentional dysfunction in
#' adults with Tourette’s syndrome: Comparison with attention deficit-
#' hyperactivity disorder. Neuropsychology, 9(2), 157–164.
#' https://doi.org/10.1037/0894-4105.9.2.157
#'
#' @source `{BFpack}` package
#' Last retrieved from CRAN: 2024-10-12
#'
"bf"
