% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/objects.R
\name{mesh3d_mesh}
\alias{mesh3d_mesh}
\title{Mesh3d 3D Model}
\usage{
mesh3d_mesh(
  mesh,
  center = FALSE,
  position = c(0, 0, 0),
  scale = c(1, 1, 1),
  angle = c(0, 0, 0),
  pivot_point = c(0, 0, 0),
  order_rotation = c(1, 2, 3),
  materialspath = NULL,
  material = material_list()
)
}
\arguments{
\item{mesh}{Mesh3d object.}

\item{center}{Default \code{FALSE}. Whether to center the mesh.}

\item{position}{Default \code{c(0,0,0)}. Position of the mesh.}

\item{scale}{Default \code{c(1,1,1)}. Scale of the mesh. Can also be a single numeric value scaling all axes uniformly.}

\item{angle}{Default \code{c(0,0,0)}. Angle to rotate the mesh.}

\item{pivot_point}{Default \code{c(0,0,0)}. Point around which to rotate the mesh.}

\item{order_rotation}{Default \code{c(1,2,3)}. Order to rotate the axes.}

\item{materialspath}{Default \code{NULL}. Path to the MTL file, if different from the OBJ file.}

\item{material}{Default \code{NULL}, read from the MTL file. If not \code{NULL}, this accepts the output
from the \code{material_list()} function to specify the material.}
}
\value{
List describing the mesh.
}
\description{
Mesh3d 3D Model
}
\examples{
if(run_documentation()) {
  # Read in a mesh3d object and rasterize it
  library(Rvcg)
  data(humface)
  
  mesh3d_mesh(humface,position = c(0,-0.3,0),scale = 1/70,
              material=material_list(diffuse="dodgerblue4", type="phong", shininess=20,
              ambient = "dodgerblue4", ambient_intensity=0.3)) |>
    rasterize_scene(lookat = c(0,0.5,1), light_info = directional_light(c(1,0.5,1)))
 }
 
 if(run_documentation()) {
  # Subdivide the mesh for a smoother appearance
  mesh3d_mesh(humface,position = c(0,-0.3,0),scale = 1/70,
              material=material_list(diffuse="dodgerblue4", type="phong", shininess=20,
              ambient = "dodgerblue4", ambient_intensity=0.3)) |>
    subdivide_mesh() |> 
    rasterize_scene(lookat = c(0,0.5,1), light_info = directional_light(c(1,0.5,1)))
 }
}
