% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/render_title.R
\name{render_title}
\alias{render_title}
\title{Render a Title on an Image}
\usage{
render_title(
  image,
  title_text = "",
  title_size = 30,
  title_offset = rep(title_size/2, 2),
  title_lineheight = 1,
  title_color = "black",
  title_font = "Arial",
  title_style = "plain",
  title_bar_color = NA,
  title_bar_alpha = 0.5,
  title_bar_width = NULL,
  title_position = NA,
  title_just = "left",
  use_magick = FALSE,
  filename = NULL,
  preview = FALSE
)
}
\arguments{
\item{image}{Image filename or 3-layer RGB array. Specifies the image to process.}

\item{title_text}{Default \code{""}. Text string to be added as the title to the image.}

\item{title_size}{Default \code{30}. Numeric value specifying the font size of the title text.}

\item{title_offset}{Default \code{c(15,15)}. Numeric vector specifying the horizontal
and vertical offset of the title text, relative to its anchor position.}

\item{title_lineheight}{Default \code{1}. Multiplier for the lineheight.}

\item{title_color}{Default \code{"black"}. String specifying the color of the title text.}

\item{title_font}{Default \code{"Arial"}. String specifying the font family for the title text.
Common options include \code{"sans"}, \code{"mono"}, \code{"serif"}, \code{"Times"}, \code{"Helvetica"}, etc.}

\item{title_style}{Default \code{"plain"}. String specifying the font style, such as
\code{"plain"}, \code{"italic"}, or \code{"bold"}.}

\item{title_bar_color}{Default \code{NULL}. Color of the optional title bar. If \code{NULL}, no bar is added.}

\item{title_bar_alpha}{Default \code{0.5}. Transparency level of the title bar. A value
between \code{0} (fully transparent) and \code{1} (fully opaque).}

\item{title_bar_width}{Default \code{NULL}. Numeric value for the height of the title bar in pixels.
If \code{NULL}, it is automatically calculated based on the text size and line breaks.}

\item{title_position}{Default \code{"northwest"}. String specifying the position of the title text.
Only used when \code{use_magick = TRUE}. Common options include \code{"northwest"}, \code{"center"}, \code{"south"}, etc.}

\item{title_just}{Default \code{"left"}. Horizontal alignment of the title text: \code{"left"},
\code{"center"}, or \code{"right"}.}

\item{use_magick}{Default \code{FALSE}. Boolean indicating whether to use the \code{magick} package for
rendering titles. This option will be deprecated in future versions.}

\item{filename}{Default \code{NULL}. String specifying the file path to save the resulting image.
If \code{NULL} and \code{preview = FALSE}, the function returns the processed RGB array.}

\item{preview}{Default \code{FALSE}. Boolean indicating whether to display the image after processing.
If \code{TRUE}, the image is displayed but not saved or returned.}
}
\value{
A 3-layer RGB array of the processed image if \code{filename = NULL} and \code{preview = FALSE}.
Otherwise, writes the image to the specified file or displays it if \code{preview = TRUE}.
}
\description{
Adds a title with optional styling and a title bar to an image.
The image can be previewed or saved to a file. Supports both the \code{grid}-based
method and (deprecated) \code{magick} package for rendering the title.
}
\note{
The \code{use_magick} parameter and all functionality tied to the \code{magick} package are
planned for deprecation. It is recommended to use the \code{grid}-based method for
future compatibility.
}
\examples{
if(run_documentation()){
#Plot the dragon
render_title(dragon, preview = TRUE, title_text = "Dragon", title_size=20)
}
if(run_documentation()){
#That's hard to see--let's add a title bar:
render_title(dragon, preview = TRUE, title_text = "Dragon", title_size=20,
         title_bar_color="white")
}
if(run_documentation()){
#Change the width of the bar:
render_title(dragon, preview = TRUE, title_text = "Dragon", title_size=20,
         title_bar_color="white", title_offset = c(8,8))
}
if(run_documentation()){
#The width of the bar will also automatically adjust for newlines:
render_title(dragon, preview = TRUE, title_text = "Dragon\n(Blue)", title_size=20,
         title_bar_color="white")
}
if(run_documentation()){
#Change the color and title color:
render_title(dragon, preview = TRUE, title_text = "Dragon", title_size=20,
         title_bar_color="red", title_color = "white")
}
if(run_documentation()){
#Change the transparency:
render_title(dragon, preview = TRUE, title_text = "Dragon",
            title_size=20, title_bar_alpha = 0.8,
            title_bar_color="red", title_color = "white")
}
if(run_documentation()){
#Read directly from a file
temp_image = tempfile(fileext = ".png")
ray_write_image(dragon, temp_image)
render_title(temp_image, preview = TRUE, title_text = "Dragon",
             title_size=20, title_bar_alpha = 0.8,
             title_bar_color="red", title_color = "white")
}
}
