% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_profile.R
\name{aws_profile}
\alias{aws_profile}
\alias{create_profile}
\alias{profile_settings}
\title{User profile configuration}
\usage{
create_profile(profile = "default", access_key = NULL,
  secret_key = NULL, region = NULL)

profile_settings(profile = "default")
}
\arguments{
\item{profile}{The profile-name. If profile was not supplied
\code{create_profile()} will create a default profile.}

\item{access_key}{The access key create by AWS.}

\item{secret_key}{The secret key create by AWS.}

\item{region}{The default region}
}
\description{
Functions to configure and visualize the user credentials. You can
see a profile settings using \code{profile_settings()} and vizualise
all profiles created using \code{list_profiles()}. The AWS CLI
saves your credentials in ~/.aws folder, so, for security reasons,
delete your credentials when you finish your work using
\code{delete_all_profiles()}.
}
\examples{
\dontrun{
# To run these examples you need the AWS CLI, use
# aws_cli_install() if it is not installed.

# create a default user
create_profile(access_key = "my_access_key_1",
               secret_key = "123456789",
               region = "us-east-1" )

# verify if the user was created
profile_settings()

# you can also create a user with a profile name
create_profile(profile = "profile_name",
               access_key = "my_access_key_2",
               secret_key = "987654321",
               region = "us-west-1")

# verify if the user was created
profile_settings(profile = "profile_name")

# remove your credentials from this computer
delete_all_profiles()
}

}
