% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/goodness.R
\name{goodness}
\alias{goodness}
\title{Evaluate if sample data for a categorical variable is consistent with a hypothesized distribution}
\usage{
goodness(
  dataset,
  var,
  p = NULL,
  tab = NULL,
  data_filter = "",
  envir = parent.frame()
)
}
\arguments{
\item{dataset}{Dataset}

\item{var}{A categorical variable}

\item{p}{Hypothesized distribution as a number, fraction, or numeric vector. If unspecified, defaults to an even distribution}

\item{tab}{Table with frequencies as alternative to dataset}

\item{data_filter}{Expression entered in, e.g., Data > View to filter the dataset in Radiant. The expression should be a string (e.g., "price > 10000")}

\item{envir}{Environment to extract data from}
}
\value{
A list of all variables used in goodness as an object of class goodness
}
\description{
Evaluate if sample data for a categorical variable is consistent with a hypothesized distribution
}
\details{
See \url{https://radiant-rstats.github.io/docs/basics/goodness.html} for an example in Radiant
}
\examples{
goodness(newspaper, "Income") \%>\% str()
goodness(newspaper, "Income", p = c(3 / 4, 1 / 4)) \%>\% str()
table(select(newspaper, Income)) \%>\% goodness(tab = .)

}
\seealso{
\code{\link{summary.goodness}} to summarize results

\code{\link{plot.goodness}} to plot results
}
