% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rPublic.R
\name{rp_getOptExp}
\alias{rp_getOptExp}
\title{Get Option Expiration Dates}
\usage{
rp_getOptExp(accountId, ticker, type)
}
\arguments{
\item{accountId}{= Public Brokerage Account Number}

\item{ticker}{= Ticker symbol: Ex. "SPY"}

\item{type}{= Ticker Type: Ex. 'EQUITY','OPTION','MULTI_LEG_INSTRUMENT', 'CRYPTO', 'ALT','TREASURY', 'BOND', 'INDEX'}
}
\value{
Retrieve option expiration dates for a specific ticker symbol as a \code{data.frame}.
}
\description{
Get Option Expiration Dates
}
\examples{
\dontrun{
 # Fetches Option Expiry Dates Available
 my_acc <- rp_getAccts()
 rp_getOptExp(accountId = my_acc$accountId, ticker = "TSLA", type="EQUITY")
}
}
