% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/runbab.R
\name{runbab}
\alias{runbab}
\title{Branch and bound algorithm implementation}
\usage{
runbab(sCat, ssh, ssb, nMax = 100)
}
\arguments{
\item{sCat}{Category matrix, output of getCat function}

\item{ssh}{current Heuristic as provided by SingleStep function}

\item{ssb}{current Bound as provided by SingleStep function}

\item{nMax}{Maximum number of steps for the algorithm, the algorithm may stop sooner if it converges.}
}
\value{
A list, including the heuristic and the bound for the number of true discoveries, along with number of steps
taken and convergence status.
}
\description{
Performs B&B when the bound are not exact
}
\examples{

#number of features per omic data set
n_cols<-100
n_rows<-120

#random matrix of p-values
set.seed(1258)
pvalmat<-matrix(runif(n_rows*n_cols, min=0, max=1)^4, nrow=n_rows, ncol=n_cols)

#calculate CT parameters
gCT<-simesCT(mps=pvalmat, m=nrow(pvalmat)*ncol(pvalmat))

#define the two-way feature set
subpmat<-pvalmat[1:10,31:40]

#calculate p-categories matrix for feature set by rows
rCat<-getCat(mps=subpmat, gCT, scale="row")

#calculate the heuristic and bound
SSout<-singleStep(rCat)

#run branch nd bound
runbab(rCat, SSout$heuristic, SSout$bound, nMax=800)

}
\seealso{
\link{getCat}
 \link{singleStep}
}
