% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SSplotRecdevs.R
\name{SSplotRecdevs}
\alias{SSplotRecdevs}
\title{Plot recruitment deviations}
\usage{
SSplotRecdevs(
  replist,
  subplots = 1:3,
  plot = TRUE,
  print = FALSE,
  add = FALSE,
  uncertainty = TRUE,
  minyr = -Inf,
  maxyr = Inf,
  forecastplot = FALSE,
  col1 = "black",
  col2 = "blue",
  col3 = "green3",
  col4 = "red",
  legendloc = "topleft",
  labels = c("Year", "Asymptotic standard error estimate", "Log recruitment deviation",
    "Bias adjustment fraction, 1 - stddev^2 / sigmaR^2"),
  pwidth = 6.5,
  pheight = 5,
  punits = "in",
  res = 300,
  ptsize = 10,
  cex.main = 1,
  plotdir = "default",
  verbose = TRUE
)
}
\arguments{
\item{replist}{A list object created by \code{\link{SS_output}()}.}

\item{subplots}{vector controlling which subplots to create}

\item{plot}{plot to active plot device?}

\item{print}{print to PNG files?}

\item{add}{add to existing plot (not yet implemented)}

\item{uncertainty}{include plots showing uncertainty?}

\item{minyr}{optional input for minimum year to show in plots}

\item{maxyr}{optional input for maximum year to show in plots}

\item{forecastplot}{include points from forecast years?}

\item{col1}{first color used}

\item{col2}{second color used}

\item{col3}{third color used}

\item{col4}{fourth color used}

\item{legendloc}{location of legend. see ?legend for more info}

\item{labels}{vector of labels for plots (titles and axis labels)}

\item{pwidth}{width of plot}

\item{pheight}{height of plot}

\item{punits}{units for PNG file}

\item{res}{Resolution of plots printed to files.
The default is \code{res = 300}.}

\item{ptsize}{point size for PNG file}

\item{cex.main}{character expansion for plot titles}

\item{plotdir}{directory where PNG files will be written. by default it will
be the directory where the model was run.}

\item{verbose}{report progress to R GUI?}
}
\description{
Plot recruitment deviations and associated quantities including derived
measures related to bias adjustment.
}
\seealso{
\code{\link[=SS_plots]{SS_plots()}}, \code{\link[=SS_fitbiasramp]{SS_fitbiasramp()}}
}
\author{
Ian Taylor, Ian Stewart
}
