% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/copy_SS_inputs.R
\name{copy_SS_inputs}
\alias{copy_SS_inputs}
\title{Copy a the Stock Synthesis input files from one directory to another}
\usage{
copy_SS_inputs(
  dir.old = NULL,
  dir.new = NULL,
  create.dir = TRUE,
  overwrite = FALSE,
  recursive = FALSE,
  use_ss_new = FALSE,
  copy_exe = FALSE,
  copy_par = FALSE,
  dir.exe = NULL,
  verbose = TRUE
)
}
\arguments{
\item{dir.old}{Location of model files to be copied, either an absolute
path or relative to the working directory.}

\item{dir.new}{New location to which the files should be copied,
either an absolute path or relative to the working directory.}

\item{create.dir}{Create dir.new directory if it doesn't exist already?}

\item{overwrite}{Overwrite existing files with matching names?}

\item{recursive}{logical. Should elements of the path other than the last be
created?}

\item{use_ss_new}{Use .ss_new files instead of original inputs?}

\item{copy_exe}{Copy any executables found in dir.old to dir.new or
dir.exe (if provided)?}

\item{copy_par}{Copy any .par files found in dir.old to dir.new?}

\item{dir.exe}{Path to executable to copy instead of any in dir.old}

\item{verbose}{Return updates of function progress to the R console?}
}
\value{
Logical indicating whether all input files were copied successfully.
}
\description{
Reads the starter.ss file to figure out the names of the control and
data files, than copies those files along with starter.ss, forecast.ss,
and wtatage.ss (if present) to a new directory, as specified.
}
\examples{
\dontrun{
copy_SS_inputs(
  dir.old = "c:/SS/old_model",
  dir.new = "c:/SS/new_model"
)
}

}
\author{
Ian Taylor
}
