% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qk_to_polygon_functions.R
\name{quadkey_to_polygon}
\alias{quadkey_to_polygon}
\title{Convert a QuadKey into a square polygon}
\usage{
quadkey_to_polygon(quadkey)
}
\arguments{
\item{quadkey}{The QuadKey as a string}
}
\value{
A \code{sf} POLYGON data.frame with a \code{quadkey} and \code{geometry} column.
}
\description{
This functions creates a \code{sf} POLYGON data.frame from a QuadKey string.
}
\examples{

# Quadkey as string
quadkey_to_polygon(quadkey = "213")

# QuadKeys as column in a data.frame
# get data file
path <- paste0(
  system.file("extdata", package = "quadkeyr"),
  "/cityA_2020_04_15_0000.csv"
)
data <- read.csv(path)
data <- format_fb_data(data)

quadkey_df_to_polygon(data = data)

}
\seealso{
\code{\link{quadkey_df_to_polygon}}
}
