% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_svg.R
\name{generate_svg}
\alias{generate_svg}
\alias{generate_svg.default}
\alias{generate_svg.qr_code}
\alias{generate_svg.qr_wifi}
\alias{generate_svg.qr_logo}
\title{Generate the QR code as an svg file}
\usage{
generate_svg(
  qrcode,
  filename,
  size = 300,
  foreground = "black",
  background = "white",
  show = interactive(),
  ...
)

\method{generate_svg}{default}(
  qrcode,
  filename,
  size = 300,
  foreground = "black",
  background = "white",
  show = interactive(),
  ...
)

\method{generate_svg}{qr_code}(
  qrcode,
  filename,
  size = 300,
  foreground = "black",
  background = "white",
  show = interactive(),
  ...
)

\method{generate_svg}{qr_wifi}(
  qrcode,
  filename,
  size = 300,
  foreground = "black",
  background = "white",
  show = interactive(),
  ...,
  fontsize = 15
)

\method{generate_svg}{qr_logo}(
  qrcode,
  filename,
  size = 300,
  foreground = "black",
  background = "white",
  show = interactive(),
  ...
)
}
\arguments{
\item{qrcode}{a \code{qr_code} object as generated by \code{qr_code}.}

\item{filename}{Where to store the QR code as svg file.
Silently overwrites existing files.
Tries to create the path, when it doesn't exist.}

\item{size}{width of the svg file in pixels.
Defaults to \code{300}.}

\item{foreground}{Stroke and fill colour for the foreground.
Use a valid \href{https://www.w3schools.com/colors/}{CSS colour}.
Defaults to \code{"black"}.}

\item{background}{Fill colour for the background.
Use a valid \href{https://www.w3schools.com/colors/}{CSS colour}.
Defaults to \code{"white"}.}

\item{show}{Open the file after creating it.
Defaults to \code{TRUE} on \code{\link[=interactive]{interactive()}} sessions, otherwise \code{FALSE}.}

\item{...}{Currently ignored.}

\item{fontsize}{The size of the font in pixels.}
}
\value{
invisible \code{NULL}
}
\description{
Create the QR code using \code{\link[=qr_code]{qr_code()}} and save it as an svg file.
}
\examples{
code <- qr_code("HELLO WORLD")
generate_svg(
  qrcode = code, filename = tempfile(fileext = ".svg"), show = FALSE
)
}
\seealso{
Other qr: 
\code{\link{coordinates}()},
\code{\link{plot.qr_code}()},
\code{\link{print.qr_code}()},
\code{\link{qr_code}()},
\code{\link{qr_event}()},
\code{\link{qr_location}()},
\code{\link{qr_sepa}()},
\code{\link{qr_wifi}()}
}
\author{
Thierry Onkelinx
}
\concept{qr}
