% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidyinfo.R
\name{tidyinfo}
\alias{tidyinfo}
\title{Formats raw financial data.}
\usage{
tidyinfo(x)
}
\arguments{
\item{x}{A list of lists of financial statements. 
Generated from get_info(companies).}
}
\value{
Returns a data set that is usable by the 
other functions of this package, as well as being 
generally more readable.

data.frame of cleaned info (cash flows, income statements, balance sheets)
}
\description{
\code{tidyinfo} works by formatting and curtailing the 
raw data generated by quantmod (and, by extension, 
the \code{get_info} function of this package)
}
\examples{
\donttest{
if (reticulate::py_module_available("yfinance")) {
  my_companies <- data.frame(ticker = c('GOOG', 'IBM'))
  raw_data <- get_info(my_companies)
  financials <- tidyinfo(raw_data)
}
}

}
\seealso{
\code{\link{get_info}}

\code{\link{tidy_cashflows}}

\code{\link{tidy_balancesheets}}

\code{\link{tidy_incomestatements}}
}
