% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/market_profitability.R
\name{market_profitability}
\alias{market_profitability}
\title{Collects profitability z-scores for companies}
\usage{
market_profitability(
  companies = qmj::companies_r3k16,
  financials = qmj::financials_r3k16
)
}
\arguments{
\item{companies}{A data frame of company names and tickers.
Requires a 'ticker' column. Defaults to provided companies
data set.}

\item{financials}{A data frame containing financial 
statements for every company. Defaults to provided
financial data set.}
}
\value{
Whatdata.frame of market profitability values
}
\description{
Given a data frame of companies (names and tickers) and
a data frame of financial statements, calculates GPOA, 
ROE, ROA, CFOA, GMAR, ACC and determines the z-score of 
overall profitability for each company based on the paper 
Quality Minus Junk (Asness et al.) in Appendix page A2.
}
\examples{
market_profitability(companies_r3k16[1,], financials_r3k16)
}
\seealso{
\code{\link{market_data}}

\code{\link{market_growth}}

\code{\link{market_safety}}

\code{\link{market_payouts}}
}
