% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/medr.R
\name{medr}
\alias{medr}
\title{Median r}
\usage{
medr(df)
}
\arguments{
\item{df}{data frame consisting only of variables for which a median intercorrelation is desired}
}
\description{
Computes the median intercorrelation among a set of variables
}
\details{
The data frame should contain only the variables for which a median intercorrelation is desired. For Westen and Rosenthal's (2003) QCV
procedure, the data frame should contain only participants' scores on the criterion variables.

This prcoedure handles missing data via the "pairwise.complete.obs" option.
}
\examples{
data(motdat)
motdatc <- motdat[,2:13] #To retain only the criterion variables (dropping the focal test score)
medr(motdatc)
}
