% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_diagnostics.R
\name{diagnose_model}
\alias{diagnose_model}
\title{Automated Model Diagnostics and Recommendations}
\usage{
diagnose_model(model, checks = "all", verbose = TRUE)
}
\arguments{
\item{model}{A fitted qbrms model object}

\item{checks}{Character vector specifying which checks to perform. Options:
"all" (default), "convergence", "fit", "residuals", "posterior", "influential"}

\item{verbose}{Logical; if TRUE, prints detailed diagnostic information
(default: TRUE)}
}
\value{
An object of class "qbrms_diagnostics" containing:
\itemize{
\item \code{summary}: Overall assessment (pass/warning/fail)
\item \code{checks}: Detailed results for each diagnostic check
\item \code{recommendations}: Specific suggestions for improvement
\item \code{plots}: List of diagnostic plots
}
}
\description{
Comprehensive automated diagnostics for qbrms models with actionable
recommendations for model improvement.
}
\details{
This function performs comprehensive model diagnostics including:
\itemize{
\item Convergence checks (for MCMC-based inference)
\item Goodness-of-fit assessment
\item Residual analysis
\item Posterior predictive checks
\item Influential observation detection
\item Prior-posterior overlap assessment
}

Each check produces a pass/warning/fail status with specific recommendations
for addressing any issues detected.
}
\examples{
\dontrun{
# Fit a model
fit <- qbrms(mpg ~ hp + wt, data = mtcars, family = gaussian())

# Run diagnostics
diag <- diagnose_model(fit)

# View summary
print(diag)

# View specific recommendations
diag$recommendations

# Create diagnostic plots
plot(diag)
}

}
