% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/item_char.R
\name{item_char}
\alias{item_char}
\title{Generate Data for Item Characteristic Curves}
\usage{
item_char(vote_num, x = NULL, post_samples)
}
\arguments{
\item{vote_num}{The vote number of the issue to be reviewed. This refers to numbers
in the column names of the input vote matrix, not the clerk session vote number.}

\item{x}{A vector showing the range of beta in the x axis.}

\item{post_samples}{A list of posterior samples of parameters obtained from `sample_pum_static` in `pumBayes`.}
}
\value{
A data frame containing `beta_samples`, mean probabilities (`means`),
and confidence intervals (`ci_lower` and `ci_upper`) for the input issue,
which can be used to plot the item characteristic curve.
}
\description{
This function calculates the data needed to plot the item characteristic
curve for a specific issue based on posterior samples.
}
\examples{
data(h116)
h116.c = preprocess_rollcall(h116)
hyperparams <- list(beta_mean = 0, beta_var = 1, alpha_mean = c(0, 0),
                    alpha_scale = 5, delta_mean = c(-2, 10), delta_scale = sqrt(10))
control <- list(num_iter = 2, burn_in = 0, keep_iter = 1, flip_rate = 0.1)
h116.c.pum <- sample_pum_static(h116.c, hyperparams,
                                  control, pos_leg = grep("SCALISE", rownames(h116.c$votes)),
                                  verbose = FALSE, pre_run = NULL, appended = FALSE)
item_data <- item_char(vote_num = 5, x = c(-4,2), post_samples = h116.c.pum)
}
