% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sp_features.R
\name{dcount_xy}
\alias{dcount_xy}
\title{Count of points within distance of polygon}
\usage{
dcount_xy(base, feat, d, weight = 1)
}
\arguments{
\item{base}{base dataset (eg gridcells), needs to be SpatialPolygonsDataFrame}

\item{feat}{feature dataset (eg another crime generator), needs to be SpatialPointsDataFrame}

\item{d}{scaler distance to count (based on polygon boundary for base, not centroid)}

\item{weight}{if 1 (default), does not use weights, else pass in string that is the variable name for weights in \code{feat}}
}
\value{
A vector of counts (or weighted sums)
}
\description{
Given a base X/Y dataset, calculates number of feature points that are within particular distance
}
\details{
This generates a count (or weighted count) of features within specified distance of the \code{base} \emph{polygon} border.
Both should be projected in the same units. Uses \code{raster::buffer()} on \code{feat} dataset (which calls \code{rgeos}) and \code{sp::over} functions.
}
\examples{
\donttest{
data(nyc_cafe); data(nyc_bor)
gr_nyc <- prep_grid(nyc_bor,15000)
gr_nyc$dcafe_8k <- dcount_xy(gr_nyc,nyc_cafe,8000)
head(gr_nyc@data)
}

}
\references{
Groff, E. R. (2014). Quantifying the exposure of street segments to drinking places nearby. \emph{Journal of Quantitative Criminology}, 30(3), 527-548.
}
\seealso{
\code{\link[=dist_xy]{dist_xy()}} for calculating distance to nearest

\code{\link[=count_xy]{count_xy()}} for counting points inside polygon

\code{\link[=kern_xy]{kern_xy()}} for estimating gaussian density of points for features at base polygon xy coords

\code{\link[=bisq_xy]{bisq_xy()}} to estimate bi-square kernel weights of points for features at base polygon xy coords

\code{\link[=idw_xy]{idw_xy()}} to estimate inverse distance weights of points for features at base polygon xy coords
}
