% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_sp2d.R
\name{plot_sp2d}
\alias{plot_sp2d}
\title{Plot and mapping spatial trends.}
\usage{
plot_sp2d(
  object,
  data,
  coordinates = NULL,
  npoints = 300,
  cexpoints = 0.25,
  addcontour = TRUE,
  addpoints = TRUE,
  addmain = TRUE,
  addint = TRUE
)
}
\arguments{
\item{object}{object returned from \code{\link{pspatfit}}}

\item{data}{either sf or dataframe with the data.}

\item{coordinates}{coordinates matrix if \code{data} is not an sf object.}

\item{npoints}{number of points to use in the interpolation.}

\item{cexpoints}{size of the points. Default = 0.25}

\item{addcontour}{Logical value to add contour lines.}

\item{addpoints}{Logical value to add spatial points to the graphics.}

\item{addmain}{Add f1_main and f2_main plots in psanova case.}

\item{addint}{Add f12_int in psanova case.}
}
\value{
plots and maps of the spatial trends
}
\description{
Make plots and maps of the spatial trends 
  in 2d of the objects fitted with \code{\link{pspatfit}} function.
}
\examples{
library(pspatreg)
######## EXAMPLE 2D WITH AMES DATA 
######## getting and preparing the data
library(spdep)
ames <- AmesHousing::make_ames() # Raw Ames Housing Data
ames_sf <- st_as_sf(ames, coords = c("Longitude", "Latitude"))
ames_sf$Longitude <- ames$Longitude
ames_sf$Latitude <- ames$Latitude
ames_sf$lnSale_Price <- log(ames_sf$Sale_Price)
ames_sf$lnLot_Area <- log(ames_sf$Lot_Area)
ames_sf$lnTotal_Bsmt_SF <- log(ames_sf$Total_Bsmt_SF+1)
ames_sf$lnGr_Liv_Area <- log(ames_sf$Gr_Liv_Area)
ames_sf1 <- ames_sf[(duplicated(ames_sf$Longitude) == FALSE), ]

######## formula of the model in Ames
form2d <- lnSale_Price ~ Fireplaces + Garage_Cars +
          pspl(lnLot_Area, nknots = 20) + 
          pspl(lnTotal_Bsmt_SF, nknots = 20) +
          pspl(lnGr_Liv_Area, nknots = 20) +
          pspt(Longitude, Latitude, 
               nknots = c(10, 10), 
               psanova = FALSE)
\donttest{
########### Constructing the spatial weights matrix
coord_sf1 <- cbind(ames_sf1$Longitude, ames_sf1$Latitude)
k5nb <- knn2nb(knearneigh(coord_sf1, k = 5, 
                          longlat = TRUE, use_kd_tree = FALSE), sym = TRUE)
lw_ames <- nb2listw(k5nb, style = "W", 
                  zero.policy = FALSE)

######## fit the model
sp2dsar <- pspatfit(form2d, data = ames_sf1, 
                    listw = lw_ames, 
                    method = "Chebyshev", 
                    type = "sar")
summary(sp2dsar)

####### plot spatial trend for spatial point coordinate
plot_sp2d(sp2dsar, data = ames_sf1)

###### MODEL WITH ANOVA DESCOMPOSITION
 form2d_psanova <- lnSale_Price ~ Fireplaces + Garage_Cars +
                   pspl(lnLot_Area, nknots = 20) + 
                   pspl(lnTotal_Bsmt_SF, nknots = 20) +
                   pspl(lnGr_Liv_Area, nknots = 20) +
                   pspt(Longitude, Latitude, 
                        nknots = c(10, 10), 
                        psanova = TRUE)
      
sp2danovasar <- pspatfit(form2d_psanova, 
                        data = ames_sf1, 
                        listw = lw_ames,
                        method = "Chebyshev", 
                        type = "sar")
summary(sp2danovasar)                         
                        
###### PLOT ANOVA DESCOMPOSITION MODEL
plot_sp2d(sp2danovasar, data = ames_sf1, 
          addmain = TRUE, addint = TRUE)
}           
}
\references{
\itemize{ 
  \item Lee, D. and Durban, M. (2011). P-Spline ANOVA Type Interaction 
    Models for Spatio-Temporal Smoothing. \emph{Statistical Modelling}, 
    (11), 49-69. <doi:10.1177/1471082X1001100104>
    
  \item Eilers, P. and Marx, B. (2021). \emph{Practical Smoothing. 
  The Joys of P-Splines}. Cambridge University Press.
    
  \item Fahrmeir, L.; Kneib, T.;  Lang, S.; and Marx, B. (2021). 
    \emph{Regression. Models, Methods and Applications (2nd Ed.)}.
     Springer.
        
  \item Wood, S.N. (2017). \emph{Generalized Additive Models. 
  An Introduction with \code{R}} (second edition). CRC Press, Boca Raton.
 }
}
\author{
\tabular{ll}{ 
  Roman Minguez  \tab \email{roman.minguez@uclm.es} \cr
  Roberto Basile \tab \email{roberto.basile@univaq.it} \cr Maria Durban \tab
  \email{mdurban@est-econ.uc3m.es} \cr Gonzalo Espana-Heredia \tab
  \email{gehllanza@gmail.com} \cr 
 }
}
