% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/contains.R
\name{contains}
\alias{contains}
\title{Contains}
\usage{
contains(activity, n = 1)
}
\arguments{
\item{activity}{\code{\link{character}}: The activity to check. This should be an activity of the log supplied to \code{\link{check_rule}}.}

\item{n}{\code{\link{numeric}} (default \code{1}): The minimum number of times the activity should be present.
Should be greater than or equal to \code{1}. Use \code{\link{absent}} instead to check for absent (i.e. \code{n = 0}) activities.}
}
\description{
Check if the specified activity is present (contained) in a case.

The \code{contains} rule examines whether the supplied \code{activity} is present in a case or not.
The argument \code{n} can be used to set a minimum number of occurences that should be present in each case.
}
\examples{
library(bupaR)
library(eventdataR)

# Each patient should be registered at least once.
patients \%>\%
 check_rule(contains("Registration"))

# Check whether some patients have received 2 or more blood tests.
patients \%>\%
 check_rule(contains("Blood test", n = 2))
}
\seealso{
Other Cardinality rules: 
\code{\link{absent}()},
\code{\link{contains_between}()},
\code{\link{contains_exactly}()}
}
\concept{Cardinality rules}
