% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/voipred.R
\name{mu_max_trunc_bvn}
\alias{mu_max_trunc_bvn}
\title{Calculates the expected value of the maximum of two random variables with zero-truncated bivariate normal distribution
Takes a vector of mean and a 2X2 covariance matrix}
\usage{
mu_max_trunc_bvn(
  mu1,
  mu2,
  sigma1,
  sigma2,
  rho,
  precision = .Machine$double.eps
)
}
\arguments{
\item{mu1}{Mean of the first distribution}

\item{mu2}{Mean of the second distribution}

\item{sigma1}{SD of the first distribution}

\item{sigma2}{SD of the second distribution}

\item{rho}{Correlation coefficient of the two random variables}

\item{precision}{Numerical precision value}
}
\value{
A scalar value for the expected value
}
\description{
Calculates the expected value of the maximum of two random variables with zero-truncated bivariate normal distribution
Takes a vector of mean and a 2X2 covariance matrix
}
