% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/00_philippines.R
\docType{data}
\name{ppiPHL2014}
\alias{ppiPHL2014}
\title{Poverty Probability Index (PPI) lookup table for Philippines using legacy
poverty definitions}
\format{
A data frame with 6 columns and 101 rows:
\describe{
\item{\code{score}}{PPI score}
\item{\code{nl100}}{National poverty line (100\%)}
\item{\code{ppp125}}{Below $1.25 per day purchasing power parity (2005)}
\item{\code{ppp250}}{Below $2.50 per day purchasing power parity (2005)}
\item{\code{ppp500}}{Below $5.00 per day purchasing power parity (2005)}
\item{\code{ppp432}}{Below $4.32 per day purchasing power parity (1993)}
}
}
\source{
\url{https://www.povertyindex.org}
}
\usage{
ppiPHL2014
}
\description{
Poverty Probability Index (PPI) lookup table for Philippines using legacy
poverty definitions
}
\examples{
  # Access Philippines PPI table
  ppiPHL2014

  # Given a specific PPI score (from 0 - 100), get the row of poverty
  # probabilities from PPI table it corresponds to
  ppiScore <- 50
  ppiPHL2014[ppiPHL2014$score == ppiScore, ]

  # Use subset() function to get the row of poverty probabilities corresponding
  # to specific PPI score
  ppiScore <- 50
  subset(ppiPHL2014, score == ppiScore)

  # Given a specific PPI score (from 0 - 100), get a poverty probability
  # based on a specific poverty definition. In this example, the national
  # poverty line definition
  ppiScore <- 50
  ppiPHL2014[ppiPHL2014$score == ppiScore, "nl100"]

}
\keyword{datasets}
