% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GroupClustering.R
\name{posthoc}
\alias{posthoc}
\title{Group effects for GLMs and GLMMs}
\usage{
posthoc (Model, EffectIndices = NULL, EffectLabels = NULL,
         EffectsMatrix = NULL, ParBootstrap = FALSE, Nboots = 999,
         SignificanceLevel = 0.05, UpperCase = FALSE,
         RankLabels = TRUE, WaldApproximation = FALSE,
         CalcClusters = FALSE, QUIET = TRUE, PlotAdj = FALSE,
         digits = 4, padjust = NULL, Scale = 1.0, Location = 0.0,
         isBinomialModel = FALSE, BackTransform = TRUE)
}
\arguments{
\item{Model}{a model of class lm, glm, glmerMod, lme or gls.}

\item{EffectIndices}{a vector containing the indices of the effects to be
analysed (default = NULL, indicating that all the levels are used).}

\item{EffectLabels}{a character vector with the labels of the effects
(default = NULL, which implies that the corresponding labels of the model
coefficient are used).}

\item{EffectsMatrix}{matrix defining contrasts to be compared
(bypasses the EffectIndices, default is NULL, meaning that standard
inference is performed).}

\item{ParBootstrap}{logic flag indicating whether the confidence intervals
should be calculated with parametric bootstrap (default is false, i.e.
the Wald confidence interval is used). Not implemented for objects of class
lme.}

\item{Nboots}{number of bootstrap samples used for the confidence interval.
(default = 999).}

\item{SignificanceLevel}{the significance level of the pairwise comparisons
(default = 0.05).}

\item{UpperCase}{should upper case letters be used for labelling the
groups (default is FALSE).}

\item{RankLabels}{should the labels of the grouping be sorted according to
the value of the response (default=TRUE)}

\item{WaldApproximation}{logic flag indicating whether a Wald approximated
test should be used (defaut = FALSE).}

\item{CalcClusters}{should the clusters be calculated and displayed
instead of grouping (Default is FALSE)}

\item{QUIET}{flag indicating whter the (large) output of the multcomp
library should be temporarily re-directed (default = TRUE).}

\item{PlotAdj}{should the associated graph be printed(default = FALSE).}

\item{digits}{number of digits in the output (default = 4)}

\item{padjust}{method for correcting the p-values (before the calculations
are performed) as in the function p.adjust (Default is NULL, indicating
that no multiple testing corrections are used)}

\item{Scale}{a scaling factor multiplying the output table (default = 1,
i.e., no scaling is used).}

\item{Location}{a location term added to the output table (default = 0,
i.e., no location shift is performed).}

\item{isBinomialModel}{a logical flag indicating whther the model is a
binomial model different than the Bernoulli (default = FALSE, i.e. not a
binomial model).}

\item{BackTransform}{should the parameters and CIs be back transformed by
applying the inverse link function (default = TRUE)}
}
\value{
an object of (S3) class "PostHoc" with methods for print, summary,
 plot, barplot and lines defined. An object of class "PostHoc" contails the
 effects, grouping, the matrix of p-values of all pairwise comparisons, the
 graph (Gr) of adjacency, the confidence intervals of the effects, the
 significance levels, the number of digits to be used for printing, the
 list of maximal cliques of the graph Gr, the clusters (if calculated).
}
\description{
posthoc is used to group or cluster the effects of liner,
 generalised linear and generalised linear mixed models according to
 significance of pairwise tests comparing the levels of the effects.
}
\details{
The function contructs, using the supplied matrix of p-values for
 all pairwise comparisosns, an undirected graph with vertices representing
 the levels of the effects, using the convention that two vertices are
 connected by an edge iff the p-value for testing equality the two vertices
 is larger than the prefixed significance level. The maximal cliques of this
 graph form the grouping of the levels of the effects.

Perform post hoc analyses via pairwise comparisons of all the
 effect levels, or of a supplied subset of effects (using the parameter
 "EffectIndices") or even linear combinations of effects (using the
 parameter "EffectsMatrix")
}
\examples{
MM <- glm(Y ~ Treatment+0,  data=DeIdentifiedExample)
GG <- posthoc(MM)
print(GG)
}
\author{
Rodrigo Labouriau
}
\keyword{pairwise-comparisons}
\keyword{post-hoc}
