% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/win_ratio_functions.R
\name{wreg}
\alias{wreg}
\title{Win ratio regression analysis}
\usage{
wreg(Y, Z, fun = NULL, sfun = NULL, ep = 1e-06)
}
\arguments{
\item{Y}{An \eqn{n\times K} matrix for \eqn{K}-variate response data on \eqn{n} subjects.
 The entries must be numeric.
 For pseudo-efficient estimation (without specifying \code{sfun}),
 the average score across components (row means)
should be compatible with the partial order (i.e., preserve the same order for any two
comparable and ordered elements).}

\item{Z}{An \eqn{n\times p} design matrix for covariates.}

\item{fun}{User-specified win function for pairwise comparison.
It takes two arguments \eqn{y_1}
and \eqn{y_0} (both \eqn{K}-vectors) and returns 1 if \eqn{y_1} wins,
-1 if \eqn{y_0} wins, and 0 if tied. The default is \code{\link{wprod}}
for the product order of multivariate ordinal data.}

\item{sfun}{The scoring function used in pseudo-efficient estimation.
The default is to take the row means of \code{Y}.}

\item{ep}{Convergence criterion in Newton-Raphson algorithm. The default is 1e-6.}
}
\value{
An object of class \code{wreg} with the following components:
\item{beta}{A vector of estimated regression coefficients.}
\item{var}{Estimated covariance matrix for \code{beta}}
\item{l}{Number of Newton-Raphson iterations.}
\item{beta_nv}{Naive (non-pseudo-efficient) estimates of \code{beta}.}
\item{se_nv}{Estimated standard errors for \code{beta_nv}.}
\item{n}{Sample size \eqn{n} of input data with non-missing values.}
\item{Nwl}{Number of comparable pairs (those with a win and loss)
out of the \eqn{n(n-1)/2} possible ones.}
}
\description{
Fit a multiplicative win-ratio regression model to
partially ordered response against covariates.
}
\examples{
head(liver)
# regress bivariate ratings against covariates
Y <- 5 - liver[, c("R1NASH", "R2NASH")] # lower score is better
Z <- cbind("Female" = liver$Sex == "F",
           liver[, c("AF", "Steatosis",   "SSF2",  "LSN")]) # covariates
obj <- wreg(Y, Z) # fit model
obj
summary(obj)
}
\references{
Mao, L. (2024). Win ratio for partially ordered data.
\emph{Statistica Sinica}, Under revision.
}
\seealso{
\code{\link{wprod}}, \code{\link{print.wreg}}, \code{\link{summary.wreg}}.
}
\keyword{wreg}
